if (typeof yndenz === 'undefined') {
    var yndenz = yndenz || function () {
        return {};
    };
}

yndenz.modules = yndenz.modules || {};

yndenz.modules.navigation = yndenz.modules.navigation || {};

yndenz.modules.navigation.navbarMenu = function (target, options) {
    this.target = target;
    this.options = options;
    this.navbar = this.target.closest('.ym-navbar');
    this.open = this.options.defaultOpen;
    this.horizontal = true;

    this.watch('open', function (prop, oldVal, val) {
        if (oldVal !== val) {
            if (val) {
                this.target.addClass('open');
                this.navbar.addClass('menu-opened');
            } else {
                this.target.removeClass('open');
                this.navbar.removeClass('menu-opened');
            }
        }

        return val;
    });

    jQuery('.ym-navbar__toggle-menu').on('click', jQuery.proxy(this.toggleOpen, this));

    this.watch('horizontal', function (prop, oldVal, val) {
        if (oldVal !== val) {
            if (val) {
                this.target.removeClass('pure-menu-vertical').addClass('pure-menu-horizontal');
            } else {
                this.target.removeClass('pure-menu-horizontal').addClass('pure-menu-vertical');
            }
        }

        return val;
    });

    jQuery(window).on('resize orientationchange', jQuery.proxy(this.checkHorizontal, this));
    this.checkHorizontal();
};

yndenz.modules.navigation.navbarMenu.prototype.toggleOpen = function () {
    this.open = !this.open;
};

yndenz.modules.navigation.navbarMenu.prototype.checkHorizontal = function () {
    this.horizontal = jQuery(window).width() >= window.gridFloatBreakpoint;
};

// option defaults
yndenz.modules.navigation.navbarMenu.defaults = {
    defaultOpen: false
};

(function ($) {
    $.fn.extend({
        navbarMenu: function (options) {
            options = $.extend({}, yndenz.modules.navigation.navbarMenu.defaults, options);

            this.each(function () {
                new yndenz.modules.navigation.navbarMenu($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });
})(jQuery);

jQuery(function () {
    jQuery('.ym-navbar__menu').navbarMenu();
});