if (typeof yndenz === 'undefined') {
    var yndenz = yndenz || function () {
        return {};
    };
}

yndenz.modules = yndenz.modules || {};

yndenz.modules.navigation = yndenz.modules.navigation || {};

yndenz.modules.navigation.navbar = function (target, options) {
    this.target = target;
    this.options = options;
    this.minify = false;

    this.watch('minify', function (prop, oldVal, val) {
        if (val) {
            this.target.addClass('minify');
        } else {
            this.target.removeClass('minify');
        }

        return val;
    });

    this.redefineBreakPoint();
    this.windowScrolled();

    jQuery(window).on('resize orientationchange', jQuery.proxy(this.redefineBreakPoint, this));
    jQuery(window).on('scroll scrollstart touchmove', jQuery.proxy(this.windowScrolled, this));
};

yndenz.modules.navigation.navbar.prototype.defineBreakPoint = function () {
    if (typeof this.options.defineBreakPoint === 'function') {
        this.breakPoint = this.options.defineBreakPoint(this.target);
    } else if (typeof this.options.defineBreakPoint === 'string' && window[this.options.defineBreakPoint]) {
        this.breakPoint = window[this.options.defineBreakPoint](this.target);
    } else {
        this.breakPoint = yndenz.modules.navigation.navbar.defaults.defineBreakPoint(this.target);
    }
    this.breakPoint = Math.max(1, this.breakPoint);
    this.minify = this.lastScrollTop > this.breakPoint;
};

yndenz.modules.navigation.navbar.prototype.redefineBreakPoint = function () {
    this.defineBreakPoint();
    setTimeout(jQuery.proxy(this.defineBreakPoint, this), 1000);
};

yndenz.modules.navigation.navbar.prototype.windowScrolled = function () {
    this.minify = window.scrollY > this.breakPoint;
    this.lastScrollTop = window.scrollY;
};

// option defaults
yndenz.modules.navigation.navbar.defaults = {
    defineBreakPoint: (target) => {
        var breakPointElements = jQuery('.ybt-breadcrumb-cta-bar, .ybt-content');
        if (breakPointElements.length) {
            return Math.max(breakPointElements.eq(0).offset().top - target.height(), 1);
        }
        return 1;
    }
};

(function ($) {
    $.fn.extend({
        navbar: function (options) {
            options = $.extend({}, yndenz.modules.navigation.navbar.defaults, options);

            this.each(function () {
                new yndenz.modules.navigation.navbar($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });
})(jQuery);

jQuery(function () {
    jQuery('.ym-navbar').navbar();
});