<?php

namespace yndenz\Modules\OnPageSitemap;

use yndenz\Modules\BaseModule\BaseModule;

class OnPageSitemap extends BaseModule {

    /**
     * Register the html sitemap shortcode.
     */
    public static function register() {
        add_shortcode('html-sitemap', array(static::class, 'shortcode'));
    }

    public function shortcode($atts = array()) {
        return (new static)->display($atts);
    }

    /**
     * Display HTML sitemap.
     *
     * @param array|string $atts
     *
     * @return string
     */
    public function display($atts = array()) {
        if (!is_array($atts)) {
            $atts = shortcode_parse_atts($atts);
        }

        $output = '<ul class="ym-sitemap">';

        $pages_args = array('echo' => false, 'title_li' => '');
        if (!empty($atts) && array_key_exists('exclude-pages', $atts)) {
            $pages_args['exclude'] = $atts['exclude-pages'];
        }
        $pages_args = apply_filters('yndenz_modules_on_page_sitemap_pages_args', $pages_args);
        $output .= wp_list_pages($pages_args);

        $categories_args = array('echo' => false, 'title_li' => '');
        if (!empty($atts) && array_key_exists('exclude-categories', $atts)) {
            $categories_args['exclude'] = $atts['exclude-categories'];
        }
        $categories_args = apply_filters('yndenz_modules_on_page_sitemap_categories_args', $categories_args);
        $output .= wp_list_categories($categories_args);

        $output .= '</ul>';

        return apply_filters('yndenz_modules_on_page_sitemap_output', $output);
    }

}