<?php

namespace yndenz\Modules\PinPointMap;

use yndenz\Modules\BaseModule\BaseModule;

class PinPointMap extends BaseModule {

    /**
     * Get the scripts used for the pin point map.
     *
     * @return array
     */
    public static function getScripts() {
        return array(
            'pin-point-map-script' => array('src' => get_modules_directory_uri() . 'pin-point-map/pin-point-map.min.js')
        );
    }

    public function display() {
        $template = locate_template('modules/pin-point-map.php');
        if (empty($template)) {
            $template = dirname(__FILE__) . '/templates/pin-point-map.php';
        }

        include $template;
    }

}