if (typeof yndenz === 'undefined') {
    var yndenz = function () {
        return {};
    };
}

yndenz.modules = yndenz.modules || function () {
    return {};
};

yndenz.modules.pinPointMap = yndenz.modules.pinPointMap || function () {
    return {};
};

yndenz.modules.pinPointMap.pinPointMap = function (target, options) {
    this.target = target;
    this.options = options;
    this.markerIcon = {
        url: this.options.marker,
        size: new google.maps.Size(34, 34),
        scaledSize: new google.maps.Size(34, 34),
        origin: new google.maps.Point(0, 0),
        anchor: new google.maps.Point(17, 17)
    };

    if (this.options.markerHighlighted) {
        this.markerIconHighlighted = {
            url: this.options.markerHighlighted,
            size: new google.maps.Size(34, 34),
            scaledSize: new google.maps.Size(34, 34),
            origin: new google.maps.Point(0, 0),
            anchor: new google.maps.Point(17, 17)
        };
    }

    jQuery.get(ajaxurl + '?action=get_location_google_maps', jQuery.proxy(this.parseLocations, this));
};

yndenz.modules.pinPointMap.pinPointMap.prototype.iterify = function (arr) {
    var cur = -1;
    arr.next = function () {
        return (++cur >= this.length) ? false : this[cur];
    };
    arr.prev = function () {
        return (--cur < 0) ? false : this[cur];
    };
    arr.reset = function () {
        cur = -1;
    };
    return arr;
};

yndenz.modules.pinPointMap.pinPointMap.prototype.setup = function (config) {
    var zoom = 3;
    if (typeof this.options.zoom === 'function') {
        zoom = this.options.zoom();
    } else if (typeof this.options.zoom === 'string' && typeof window[this.options.zoom] === 'function') {
        zoom = window[this.options.zoom]();
    } else {
        zoom = this.options.zoom;
    }
    this.map = new google.maps.Map(this.target[0], {
        zoom: zoom,
        minZoom: this.options.minZoom,
        center: typeof this.options.center === 'string' ? JSON.parse(this.options.center) : this.options.center,
        mapTypeId: 'custom',
        mapTypeControl: false,
        fullscreenControl: false,
        scaleControl: false,
        streetViewControl: false,
        rotateControl: false
    });

    this.service = new google.maps.places.PlacesService(this.map);

    this.addCustomMapType(config);
    this.definePopupClass();

    this.iterify(this.locations);
    this.interval = setInterval(jQuery.proxy(this.searchPlace, this), 250);
};

yndenz.modules.pinPointMap.pinPointMap.prototype.addCustomMapType = function (config) {
    var customMapType = new google.maps.StyledMapType(config);

    this.map.mapTypes.set('custom', customMapType);
    this.map.setMapTypeId('custom');
};

yndenz.modules.pinPointMap.pinPointMap.prototype.definePopupClass = function () {
    yndenz.modules.pinPointMap.popup = function (position, content) {
        this.position = position;

        var pixelOffset = document.createElement('div');
        pixelOffset.classList.add('c-info-window__anchor');
        pixelOffset.innerHTML = content;

        this.anchor = document.createElement('div');
        this.anchor.classList.add('c-info-window');
        this.anchor.appendChild(pixelOffset);

        // Optionally stop clicks, etc., from bubbling up to the map.
        this.stopEventPropagation();
    };
    // NOTE: google.maps.OverlayView is only defined once the Maps API has
    // loaded. That is why Popup is defined inside initMap().
    yndenz.modules.pinPointMap.popup.prototype = Object.create(google.maps.OverlayView.prototype);

    /** Called when the popup is added to the map. */
    yndenz.modules.pinPointMap.popup.prototype.onAdd = function () {
        this.getPanes().floatPane.appendChild(this.anchor);
    };

    /** Called when the popup is removed from the map. */
    yndenz.modules.pinPointMap.popup.prototype.onRemove = function () {
        if (this.anchor.parentElement) {
            this.anchor.parentElement.removeChild(this.anchor);
        }
    };

    /** Called when the popup needs to draw itself. */
    yndenz.modules.pinPointMap.popup.prototype.draw = function () {
        var divPosition = this.getProjection().fromLatLngToDivPixel(this.position);
        // Hide the popup when it is far out of view.
        var display = Math.abs(divPosition.x) < 4000 && Math.abs(divPosition.y) < 4000 ? 'block' : 'none';

        if (display === 'block') {
            this.anchor.style.left = divPosition.x + 'px';
            this.anchor.style.top = divPosition.y + 'px';
        }
        if (this.anchor.style.display !== display) {
            this.anchor.style.display = display;
        }
    };

    /** Stops clicks/drags from bubbling up to the map. */
    yndenz.modules.pinPointMap.popup.prototype.stopEventPropagation = function () {
        var anchor = this.anchor;
        anchor.style.cursor = 'auto';

        ['click', 'dblclick', 'contextmenu', 'wheel', 'mousedown', 'touchstart', 'pointerdown'].forEach(function (event) {
            anchor.addEventListener(event, function (e) {
                e.stopPropagation();
            });
        });
    };
};

yndenz.modules.pinPointMap.pinPointMap.prototype.searchPlace = function () {
    var location = this.locations.next();
    if (location) {
        this.service.textSearch({
            location: this.map.getCenter(),
            radius: '100',
            query: location.query
        }, jQuery.proxy(this.searchPlaceResult, this));
    } else {
        this.openInitialMarker();
        clearInterval(this.interval);
    }
};

yndenz.modules.pinPointMap.pinPointMap.prototype.searchPlaceResult = function (results, status) {
    if (status !== google.maps.places.PlacesServiceStatus.OK) {
        console.error(status);
        return;
    }

    if (results.length) {
        this.addMarker(results[0]);
    }
};

yndenz.modules.pinPointMap.pinPointMap.prototype.addMarker = function (result) {
    var index = -1;
    for (var i in this.locations) {
        if (this.locations[i].query && this.locations[i].query.toLowerCase().indexOf(result.name.toLowerCase()) >= 0) {
            index = parseInt(i);
            break;
        }
    }
    if (index < 0) {
        console.log(result.name + ' not found in locations listing');
    }

    var marker = new google.maps.Marker({
        position: result.geometry.location,
        map: this.map,
        index: index,
        title: this.locations[index].title,
        icon: this.markerIcon
    });

    marker.addListener('click', jQuery.proxy(this.markerClicked, this, {marker: marker, center: true}));

    this.locations[index].marker = marker;

    if (window.location.href.indexOf('/' + this.locations[index].slug + '/') > 0) {
        this.openInfoWindow(marker);
    }
};

yndenz.modules.pinPointMap.pinPointMap.prototype.markerClicked = function (marker) {
    this.openInfoWindow(marker);
    if (this.options.centerOnMarkerClick && marker.hasOwnProperty('center') && marker.center) {
        this.map.setCenter(marker.marker.position);
    }
};

yndenz.modules.pinPointMap.pinPointMap.prototype.openInfoWindow = function (options) {
    if (this.infoWindow) {
        this.infoWindow.setMap(null);
    }

    this.infoWindow = new yndenz.modules.pinPointMap.popup(options.marker.position, this.locations[options.marker.index].content);
    this.infoWindow.setMap(this.map);

    if (this.hasOwnProperty('markerIconHighlighted')) {
        this.locations.reset();
        var location;
        while (location = this.locations.next()) {
            location.marker.setIcon(options.marker === location.marker ? this.markerIconHighlighted : this.markerIcon);
        }
    }
};

yndenz.modules.pinPointMap.pinPointMap.prototype.openInitialMarker = function () {
    this.locations.reset();
    var marker = this.locations.next().marker;
    if (window.location.search) {
        var matches = window.location.search.match('(\\?|&)' + this.options.urlParameter + '=([^&]+)(&|$)');
        if (matches && matches.length > 0) {
            var location;
            while (location = this.locations.next()) {
                if (location.slug === matches[2]) {
                    marker = location.marker;
                    break;
                }
            }
        }
    }
    this.openInfoWindow({marker: marker});
};

yndenz.modules.pinPointMap.pinPointMap.prototype.parseLocations = function (response) {
    if (typeof response === 'string') {
        this.locations = JSON.parse(response);
    } else {
        this.locations = response;
    }
    jQuery.get(this.options.customMap, jQuery.proxy(this.setup, this));
};

yndenz.modules.pinPointMap.pinPointMap.defaults = {
    zoom: function () {
        return 3;
    },
    minZoom: 2,
    center: {lat: 22, lng: 22},
    locations: [],
    marker: '',
    markerHighlighted: '',
    customMap: '',
    urlParameter: 'location',
    centerOnMarkerClick: true
};

(function ($) {
    $.fn.extend({
        pinPointMap: function (options) {
            options = $.extend({}, yndenz.modules.pinPointMap.pinPointMap.defaults, options);

            this.each(function () {
                new yndenz.modules.pinPointMap.pinPointMap($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });
})(jQuery);

function initPinPointMap() {
    jQuery('.ym-pin-point-map__google-maps').pinPointMap();
}

jQuery(function () {
    var locationMap = jQuery('.ym-pin-point-map__google-maps');
    if (locationMap && locationMap.length && window.hasOwnProperty('googleMapsAPIKey')) {
        var e = jQuery('<script/>');
        e.attr('src', 'https://maps.googleapis.com/maps/api/js?callback=initLocationMap&libraries=places,visualization&key=' + window.googleMapsAPIKey);
        e.attr('async', true);
        e.attr('defer', true);
        jQuery('body').append(e);
    }
});