if (typeof yndenz === 'undefined') {
    var yndenz = function () {
        return {};
    };
}

yndenz.modules = yndenz.modules || function () {
    return {};
};

yndenz.modules.popup = yndenz.modules.popup || function () {
    return {};
};

yndenz.modules.popup.popup = function (target, options) {
    this.target = target;
    this.options = options;

    this.show = false;

    this.watch('show', function (prop, oldVal, val) {
        if (val) {
            this.target.addClass('show');
            if (this.options.fade) {
                this.target.addClass('in');
            }
        } else {
            if (this.options.fade) {
                this.target.removeClass('in').delay(600).queue(function () {
                    jQuery(this).removeClass('show');
                    jQuery(this).dequeue();
                });
            } else {
                this.target.removeClass('show');
            }
        }
        return val;
    });

    if (this.options.fade) {
        this.target.addClass('fade');
    }

    jQuery(document).on('click', '[data-toggle="popup"][data-target="#' + this.target.attr('id') + '"]', jQuery.proxy(this.toggleShow, this));
    this.target.find('.ym-popup__close').on('click', jQuery.proxy(this.toggleShow, this));
    this.target.on('click', jQuery.proxy(this.checkHide, this));
};

yndenz.modules.popup.popup.prototype.toggleShow = function () {
    this.show = !this.show;
};

yndenz.modules.popup.popup.prototype.checkHide = function (e) {
    if (jQuery(e.target).closest('.ym-popup__content').length === 0) {
        this.toggleShow();
    }
};

yndenz.modules.popup.popup.defaults = {
    fade: true
};

(function ($) {
    $.fn.extend({
        popup: function (options) {
            options = $.extend({}, yndenz.modules.popup.popup.defaults, options);

            this.each(function () {
                new yndenz.modules.popup.popup($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });
})(jQuery);

jQuery(function () {
    jQuery('.ym-popup').popup();
});