<?php

namespace yndenz\Modules\Popup;

use yndenz\Modules\BaseModule\BaseModule;

class Popup extends BaseModule {

	public static function register() {
		add_shortcode( 'popup', array( static::class, 'shortcode' ) );
	}

	/**
	 * Get the scripts used for the popup.
	 *
	 * @return array
	 */
	public static function getScripts() {
		return array(
			'popup-script' => array( 'src' => get_modules_directory_uri() . 'popup/popup.min.js' )
		);
	}

	/**
	 * Display a popup.
	 *
	 * @param array|string $atts A list of attributes added to the shortcode.
	 * @param string       $content
	 *
	 * @return string
	 */
	public static function shortcode( $atts = array(), $content = '' ) {
		ob_start();
		( new static )->display( $atts, $content );

		return ob_get_clean();
	}

	/**
	 * Display a popup.
	 *
	 * @param array|string $args A list of attributes added to the shortcode.
	 * @param string       $content
	 */
	public function display( $args, $content ) {
		if ( ! is_array( $args ) ) {
			$args = shortcode_parse_atts( $args );
		}

		$fade = true;
		if ( ! empty( $args ) && array_key_exists( 'fade', $args ) ) {
			$fade = boolval( $args['fade'] );
		}

		$id = '';
		if ( ! empty( $args ) && array_key_exists( 'id', $args ) ) {
			$id = $args['id'];
		}

		if ( empty( $id ) ) {
			$id = sanitize_title( uniqid( 'popup-', true ) );
		}

		$title = '';
		if ( ! empty( $args ) && array_key_exists( 'title', $args ) ) {
			$title = $args['title'];
		}

		$actions = '';
		if ( ! empty( $content ) && strpos( $content, '[actions]' ) ) {
			$start   = strpos( $content, '[actions]' );
			$length  = strpos( $content, '[/actions]' ) + 10 - $start;
			$actions = substr( $content, $start + 9, $length - 19 );
			$content = substr_replace( $content, '', $start, $length );
		}

		add_filter( 'base_theme_basics_scripts', array( static::class, 'addScripts' ) );

		$template = locate_template( 'modules/popup.php' );
		if ( empty( $template ) ) {
			$template = dirname( __FILE__ ) . '/templates/popup.php';
		}

		include $template;
	}

}