<div class="ym-recent-posts">
	<?php while ( have_posts() ) : the_post(); ?>
        <article id="post-<?php the_ID(); ?>" <?php post_class( 'ym-recent-posts__item' ); ?>>
            <header class="ym-recent-posts__item-header">
	            <?php if ( $show_thumbnail ) : ?>
                    <a href="<?php the_permalink(); ?>" class="ym-recent-posts__image-container"
                       title="<?php the_seo_title(); ?>">
                        <span class="ym-recent-posts__image-wrapper">
                            <?php
                            if ( class_exists( '\\yndenz\\Modules\\Banner\\Banner' ) ) :
	                            $banner = new \yndenz\Modules\Banner\Banner();
	                            $banner->initialize( null, 'medium' );
	                            $banner->displayImage();
                            elseif ( has_post_thumbnail() ) :
	                            the_post_thumbnail();
                            endif;
                            ?>
                        </span>
                    </a>
	            <?php endif; ?>
                <h3 class="ym-recent-posts__item-title">
                    <a href="<?php the_permalink(); ?>"
                       title="<?php the_seo_title(); ?>">
	                    <?php the_title(); ?>
                    </a>
                </h3>
	            <?php if ( $show_date ) : ?>
                    <p class="ym-recent-posts__item-date">
                        <time datetime="<?php echo get_the_date( 'c' ); ?>">
                            <small><?php the_time( get_option( 'date_format' ) ); ?></small>
                        </time>
                    </p>
	            <?php endif; ?>
            </header>
			<?php if ( $show_excerpt ) : ?>
                <p class="ym-recent-posts__item-content"><?php the_excerpt(); ?></p>
			<?php endif; ?>
            <p class="ym-recent-posts__read-more">
	            <?php echo do_shortcode( '[read_more_button]' ); ?>
            </p>
        </article>
	<?php endwhile; ?>
</div>