<?php

namespace yndenz\Modules\RecentPosts;

use WP_Widget;

class RecentPostsWidget extends WP_Widget {

	public function __construct() {
		parent::__construct(
			'recent_posts_widget',
			_x( 'Meest recente berichten (by yndenz)', 'Back-end widgets', 'base-theme' ),
			array(
				'description' => _x( 'Een uitgebreide variant van de meest recente berichten widget.', 'Back-end widgets', 'base-theme' )
			)
		);
	}

	public static function init() {
		add_action( 'widgets_init', array( static::class, 'register' ) );
	}

	public static function register() {
		register_widget( static::class );
	}

	public function widget( $args, $instance ) {
		$title = apply_filters( 'widget_title', $instance['title'] );

		echo $args['before_widget'];

		if ( ! empty( $title ) ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}

		$query_args = array(
			'post__not_in'   => array( get_the_ID() ),
			'posts_per_page' => 5,
			'post_type'      => 'post',
			'post-status'    => 'publish',
			'orderby'        => 'date',
			'order'          => 'DESC'
		);
		if ( ! empty( $instance['category__in'] ) ) {
			$query_args['category__in'] = explode( ',', $instance['category__in'] );
		}
		if ( ! empty( $instance['numposts'] ) ) {
			$query_args['posts_per_page'] = (int) $instance['numposts'];
		}

		$this->displayList( $query_args, $instance );

		echo $args['after_widget'];
	}

	public function displayList( $query_args, $options ) {
		query_posts( $query_args );

		if ( have_posts() ) {
			extract( $options );

			$template = locate_template( 'modules/recent-posts.php' );
			if ( empty( $template ) ) {
				$template = dirname( __FILE__ ) . '/templates/recent-posts.php';
			}

			include $template;
		}

		wp_reset_query();
		wp_reset_postdata();
	}

	public function form( $instance ) {
		include dirname( __FILE__ ) . '/templates/widget-options.php';
	}

	public function update( $new_instance, $old_instance ) {
		$instance                   = array();
		$instance['title']          = ! empty( $new_instance['title'] ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['category__in']   = ! empty( $new_instance['category__in'] ) ? implode( array_keys( $new_instance['category__in'] ) ) : '';
		$instance['numposts']       = ! empty( $new_instance['numposts'] ) ? strip_tags( $new_instance['numposts'] ) : '5';
		$instance['show_thumbnail'] = ! empty( $new_instance['show_thumbnail'] ) ? 1 : 0;
		$instance['show_date']      = ! empty( $new_instance['show_date'] ) ? 1 : 0;
		$instance['show_excerpt']   = ! empty( $new_instance['show_excerpt'] ) ? 1 : 0;

		return $instance;
	}

}