<?php

namespace yndenz\Modules\RelatedPosts;

use yndenz\Modules\BaseModule\BaseModule;

class RelatedPosts extends BaseModule {

    /**
     * Register the related posts custom fields.
     */
    public static function register() {
        add_shortcode('related_posts', array(static::class, 'shortcode'));

        if (!function_exists("register_field_group")) {
            return;
        }

        $fields = array(
            array(
                'key' => 'acf-relation_type',
                'label' => __('Type', 'base-theme'),
                'name' => 'relation_type',
                'type' => 'select',
                'choices' => array(
                    'tags' => __('Tags', 'base-theme'),
                    'posts' => __('Specifiek', 'base-theme'),
                ),
                'default_value' => '',
                'allow_null' => 1,
                'multiple' => 0,
            ),
            array(
                'key' => 'acf-related_tags',
                'label' => __('Tags', 'base-theme'),
                'name' => 'related_tags',
                'type' => 'taxonomy',
                'conditional_logic' => array(
                    'status' => 1,
                    'rules' => array(
                        array(
                            'field' => 'acf-relation_type',
                            'operator' => '==',
                            'value' => 'tags',
                        ),
                    ),
                    'allorany' => 'all',
                ),
                'taxonomy' => 'post_tag',
                'field_type' => 'multi_select',
                'allow_null' => 0,
                'load_save_terms' => 0,
                'return_format' => 'id',
                'multiple' => 1,
            ),
            array(
                'key' => 'acf-related_posts',
                'label' => __('Pagina\'s en posts', 'base-theme'),
                'name' => 'related_posts',
                'type' => 'post_object',
                'conditional_logic' => array(
                    'status' => 1,
                    'rules' => array(
                        array(
                            'field' => 'acf-relation_type',
                            'operator' => '==',
                            'value' => 'posts',
                        ),
                    ),
                    'allorany' => 'all',
                ),
                'post_type' => array(
                    0 => 'post',
                    1 => 'page',
                ),
                'taxonomy' => array(
                    0 => 'all',
                ),
                'allow_null' => 1,
                'multiple' => 1,
            ),
        );

        $fields = apply_filters('yndenz_modules_related_posts_fields', $fields);

        $locations = array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'post',
                    'order_no' => 0,
                    'group_no' => 0,
                ),
            ),
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'page',
                    'order_no' => 0,
                    'group_no' => 1,
                ),
                array(
                    'param' => 'page_type',
                    'operator' => '!=',
                    'value' => 'front_page',
                    'order_no' => 1,
                    'group_no' => 1,
                ),
            ),
        );

        $locations = apply_filters('yndenz_modules_related_posts_locations', $locations);

        register_field_group(array(
            'id' => 'acf_related-posts',
            'title' => __('Gerelateerde onderwerpen', 'base-theme'),
            'fields' => $fields,
            'location' => $locations,
            'options' => array(
                'position' => 'side',
                'layout' => 'default',
                'hide_on_screen' => array(),
            ),
            'menu_order' => 0,
        ));
    }

    public static function shortcode($atts = array()) {
        return (new static)->display($atts);
    }

    /**
     * Display a listing of related posts.
     *
     * @param array|string $attr List of attributes added to the shortcode.
     *
     * @return string
     */
    public function display($attr = array()) {
        if (!is_array($attr)) {
            $attr = shortcode_parse_atts($attr);
        }
        $output = '';
        $args = array();

        $relation_type = get_post_meta(get_the_ID(), 'relation_type', true);
        switch ($relation_type) {
            case 'posts':
                $related_posts_ids = get_post_meta(get_the_ID(), 'related_posts', true);
                if (is_array($related_posts_ids) && count($related_posts_ids) > 0) {
                    array_walk($related_posts_ids, function ($post_id) {
                        return (int)$post_id;
                    });
                    $args = array(
                        'posts_per_page' => -1,
                        'ignore_sticky_posts' => true,
                        'post_type' => array('post', 'page'),
                        'post__in' => $related_posts_ids,
                        'post__not_in' => array(get_the_ID())
                    );
                }
                break;
            case 'tags':
                $related_tag_ids = get_post_meta(get_the_ID(), 'related_tags', true);
                if (is_array($related_tag_ids) && count($related_tag_ids) > 0) {
                    $args = array(
                        'posts_per_page' => 3,
                        'ignore_sticky_posts' => true,
                        'post_type' => array('post'),
                        'tag__in' => $related_tag_ids,
                        'post__not_in' => array(get_the_ID()),
                        'orderby' => 'date',
                        'order' => 'DESC'
                    );
                }
                break;
            default:
                break;
        }

        if (!empty($args)) {
            global $post;
            $original_post = $post;
            query_posts($args);
            if (have_posts()) {
                $show_list = is_array($attr) && array_key_exists('display', $attr) && $attr['display'] === 'list';

                if (is_array($attr) && array_key_exists('template', $attr)) {
                    $template = $attr['template'];
                }
                if (empty($template)) {
                    $template = locate_template('modules/related-posts.php');
                }
                if (empty($template)) {
                    $template = dirname(__FILE__) . '/templates/related-posts.php';
                }

                ob_start();
                include $template;
                $output = ob_get_clean();
            }
            wp_reset_query();
            wp_reset_postdata();
        }
        return $output;
    }

}