<?php

namespace yndenz\Modules\RelatedPosts;

use yndenz\Modules\BaseModule\BaseModule;

class RelatedPosts extends BaseModule {

	/**
	 * Register the related posts custom fields.
	 */
	public static function register() {
		add_shortcode( 'related-posts', array( static::class, 'shortcode' ) );
	}

	public static function registerFields() {
		if ( ! function_exists( "register_field_group" ) ) {
			return;
		}

		static::registerRelationType();
	}

	public static function registerRelationType() {
		$fields = array(
			array(
				'key'           => 'field_relation_type',
				'label'         => _x( 'Type', 'Back-end pagina toevoegen/bewerken', 'base-theme' ),
				'name'          => 'relation_type',
				'type'          => 'select',
				'choices'       => array(
					'tags'  => _x( 'Tags', 'Back-end pagina toevoegen/bewerken', 'base-theme' ),
					'posts' => _x( 'Specifiek', 'Back-end pagina toevoegen/bewerken', 'base-theme' ),
				),
				'default_value' => '',
				'allow_null'    => 1,
				'multiple'      => 0,
			),
			array(
				'key'               => 'field_related_tags',
				'label'             => _x( 'Tags', 'Back-end pagina toevoegen/bewerken', 'base-theme' ),
				'name'              => 'related_tags',
				'type'              => 'taxonomy',
				'conditional_logic' => array(
					'status'   => 1,
					'rules'    => array(
						array(
							'field'    => 'field_relation_type',
							'operator' => '==',
							'value'    => 'tags',
						),
					),
					'allorany' => 'all',
				),
				'taxonomy'          => 'post_tag',
				'field_type'        => 'multi_select',
				'allow_null'        => 0,
				'load_save_terms'   => 0,
				'return_format'     => 'id',
				'multiple'          => 1,
			),
			array(
				'key'               => 'field_related_posts',
				'label'             => _x( 'Pagina\'s en posts', 'Back-end pagina toevoegen/bewerken', 'base-theme' ),
				'name'              => 'related_posts',
				'type'              => 'post_object',
				'conditional_logic' => array(
					'status'   => 1,
					'rules'    => array(
						array(
							'field'    => 'field_relation_type',
							'operator' => '==',
							'value'    => 'posts',
						),
					),
					'allorany' => 'all',
				),
				'post_type'         => array(
					0 => 'post',
					1 => 'page',
				),
				'taxonomy'          => array(
					0 => 'all',
				),
				'allow_null'        => 1,
				'multiple'          => 1,
			),
		);

		$fields = apply_filters( 'yndenz_modules_related_posts_fields', $fields );

		$locations = array(
			array(
				array(
					'param'    => 'post_type',
					'operator' => '==',
					'value'    => 'post',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
			array(
				array(
					'param'    => 'post_type',
					'operator' => '==',
					'value'    => 'page',
					'order_no' => 0,
					'group_no' => 1,
				),
				array(
					'param'    => 'page_type',
					'operator' => '!=',
					'value'    => 'front_page',
					'order_no' => 1,
					'group_no' => 1,
				),
			),
		);

		$locations = apply_filters( 'yndenz_modules_related_posts_locations', $locations );

		register_field_group( array(
			'id'         => 'group_related-posts',
			'title'      => _x( 'Gerelateerde onderwerpen', 'Back-end pagina toevoegen/bewerken', 'base-theme' ),
			'fields'     => $fields,
			'location'   => $locations,
			'options'    => array(
				'position'       => 'side',
				'layout'         => 'default',
				'hide_on_screen' => array(),
			),
			'menu_order' => 0,
		) );
	}

	/**
	 * Display a listing of related posts.
	 *
	 * @param array|string $atts List of attributes added to the shortcode.
	 *
	 * @return string
	 */
	public static function shortcode( $atts = array() ) {
		ob_start();
		( new static )->display( $atts );

		return ob_get_clean();
	}

	/**
	 * Display a listing of related posts.
	 *
	 * @param array|string $args List of attributes added to the shortcode.
	 */
	public function display( $args = array() ) {
		if ( ! is_array( $args ) ) {
			$args = shortcode_parse_atts( $args );
		}

		$query_args = wp_parse_args( $args, static::initializeArgs() );

		if ( array_key_exists( 'heading', $query_args ) ) {
			unset( $query_args['heading'] );
		}

		if ( empty( $query_args ) ) {
			return;
		}

		global $post;
		$original_post = $post;

		query_posts( $query_args );

		if ( have_posts() ) {
			include static::getTemplate( $args );
		}

		wp_reset_query();
		wp_reset_postdata();
	}

	/**
	 * @return array
	 */
	public static function initializeArgs() {
		$args = array();

		$relation_type = get_post_meta( get_the_ID(), 'relation_type', true );
		switch ( $relation_type ) {
			case 'posts':
				$related_post_ids = get_post_meta( get_the_ID(), 'related_posts', true );
				if ( is_array( $related_post_ids ) && count( $related_post_ids ) > 0 ) {
					array_walk( $related_post_ids, function ( $post_id ) {
						return (int) $post_id;
					} );
					$args = array(
						'posts_per_page'      => - 1,
						'ignore_sticky_posts' => true,
						'post_type'           => array( 'post', 'page' ),
						'post__in'            => $related_post_ids,
						'post__not_in'        => array( get_the_ID() )
					);
				}
				break;
			case 'tags':
				$related_tag_ids = get_post_meta( get_the_ID(), 'related_tags', true );
				if ( is_array( $related_tag_ids ) && count( $related_tag_ids ) > 0 ) {
					$args = array(
						'posts_per_page'      => 3,
						'ignore_sticky_posts' => true,
						'post_type'           => array( 'post' ),
						'tag__in'             => $related_tag_ids,
						'post__not_in'        => array( get_the_ID() ),
						'orderby'             => 'date',
						'order'               => 'DESC'
					);
				}
				break;
			default:
				break;
		}

		return $args;
	}

	/**
	 * Determine what template file to use.
	 *
	 * @param array|string $args
	 *
	 * @return string
	 */
	public static function getTemplate( $args = array() ) {
		if ( is_array( $args ) && array_key_exists( 'template', $args ) ) {
			return $args['template'];
		}

		$template_name = 'related-posts';
		if ( is_array( $args ) && array_key_exists( 'gallery', $args ) ) {
			$template_name .= '-gallery';
		} else if ( is_array( $args ) && array_key_exists( 'display', $args ) && $args['display'] === 'list' ) {
			$template_name .= '-list';
		}

		$template = locate_template( "modules/{$template_name}.php" );
		if ( empty( $template ) ) {
			$template = dirname( __FILE__ ) . "/templates/{$template_name}.php";
		}

		return $template;
	}

}