<div class="hreview" itemscope itemtype="http://schema.org/Review">
    <meta itemprop="datePublished" content="<?php date('c', strtotime($review->date)); ?>">
    <h2>
        <span class="reviewer vcard" itemprop="author" itemscope itemtype="http://schema.org/Person">
            <span class="fn" itemprop="name">
                <?php echo apply_filters('the_content', $review->author); ?>
            </span>
        </span>
    </h2>
    <?php echo $this->result->item_reviewed; ?>
    <p class="rating" itemprop="reviewRating" itemscope itemtype="http://schema.org/Rating">
        <meta itemprop="worstRating" content="1">
        <span class="value" itemprop="ratingValue">
            <?php echo $review->rating; ?>
        </span> /
        <span class="best" itemprop="bestRating">10</span>
        <span class="stars">
            <?php for ($i = 0; $i < floor($review->rating / 2); $i++) : ?>
                <i class="fa fa-star"></i>
            <?php endfor; ?>
            <?php if ($review->rating % 2 === 1) : ?>
                <i class="fa fa-star-half-o"></i>
            <?php endif; ?>
            <?php for ($i = ceil($review->rating / 2); $i < 5; $i++) : ?>
                <i class="fa fa-star-o"></i>
            <?php endfor; ?>
        </span>
    </p>
    <p class="subheading" itemprop="headline">
        <?php echo apply_filters('the_title', $review->reason); ?>
    </p>
    <p class="dtreviewed">
        <small><?php echo strftime('%x', strtotime($review->date)); ?></small>
    </p>
    <div class="description" itemprop="reviewBody">
        <?php
        if ($full_content) :
            echo apply_filters('the_content', $review->text);
        else :
            $content = apply_filters('the_content', $review->text);
            $content = substr($content, 0, strpos($content, '</p>') + 4);
            echo $content;
        endif;
        ?>
    </div>
</div>