<div class="hreview ym-reviews__item" itemscope itemtype="http://schema.org/Review">
    <meta itemprop="datePublished" content="<?php date('c', strtotime($review->date)); ?>">
    <h2 class="ym-reviews__item-reviewer">
        <span class="reviewer vcard" itemprop="author" itemscope itemtype="http://schema.org/Person">
            <span class="fn" itemprop="name">
                <?php echo apply_filters('the_title', $review->author); ?>
            </span>
        </span>
    </h2>
    <?php echo $this->result->item_reviewed; ?>
    <p class="rating ym-reviews__item-rating" itemprop="reviewRating" itemscope itemtype="http://schema.org/Rating">
        <meta itemprop="worstRating" content="1">
        <span class="value" itemprop="ratingValue">
            <?php echo $review->rating; ?>
        </span> /
        <span class="best" itemprop="bestRating">10</span>
        <span class="ym-reviews__item-stars">
            <?php for ($i = 0; $i < floor($review->rating / 2); $i++) : ?>
                <i class="fa fa-star"></i>
            <?php endfor; ?>
            <?php if ($review->rating % 2 === 1) : ?>
                <i class="fa fa-star-half-o"></i>
            <?php endif; ?>
            <?php for ($i = ceil($review->rating / 2); $i < 5; $i++) : ?>
                <i class="fa fa-star-o"></i>
            <?php endfor; ?>
        </span>
    </p>
    <p class="ym-reviews__item-subheading" itemprop="headline">
        <?php echo apply_filters('the_title', $review->reason); ?>
    </p>
    <p class="ym-reviews__item-date dtreviewed">
        <small><?php echo strftime('%x', strtotime($review->date)); ?></small>
    </p>
    <div class="ym-reviews__item-description" itemprop="reviewBody">
        <?php
        if ($full_content) :
            echo apply_filters('the_content', $review->text);
        else :
            $content = apply_filters('the_content', $review->text);
            $content = substr($content, 0, strpos($content, '</p>') + 4);
            echo $content;
        endif;
        ?>
    </div>
    <?php if ($show_read_more) : ?>
        <p class="ym-reviews__read-more">
            <a href="<?php echo get_permalink(270472); ?>"
               title="<?php echo get_seo_title(get_post(270472)); ?>">
                <?php _e('Lees meer', 'base-theme'); ?> &raquo;
            </a>
        </p>
    <?php endif; ?>
</div>