<div class="ym-reviews--gallery ym-gallery">
    <div class="ym-gallery__carousel" role="listbox">
		<?php
		$active       = true;
		$column_class = '';
		if ( $items_per_slide > 1 ) :
			$column_class = 'pure-u-sm-1-' . $items_per_slide;
		endif;
		foreach ( $reviews as $i => $chunk ) :
			if ( $items_per_slide > 1 && count( $chunk ) === 1 && $i > 0 ) :
				continue;
			endif;
			?>
            <div class="slide<?php echo $i === 0 ? ' active' : ''; ?>" role="option">
                <div class="pure-g">
					<?php foreach ( $chunk as $review ) : ?>
                        <div class="pure-u-1 <?php echo $column_class; ?>">
							<?php $this->display( $review ); ?>
                        </div>
					<?php endforeach; ?>
                </div>
            </div>
		<?php endforeach; ?>
    </div>

	<?php if ( $show_controls ) : ?>
        <button class="ym-gallery__control prev" type="button">
            <i class="fa fa-chevron-left" aria-hidden="true"></i>
            <span class="sr-only"><?php _ex( 'Vorige', 'Carousel navigatie', 'base-theme' ); ?></span>
        </button>
        <button class="ym-gallery__control next" type="button">
            <i class="fa fa-chevron-right" aria-hidden="true"></i>
            <span class="sr-only"><?php _ex( 'Volgende', 'Carousel navigatie', 'base-theme' ); ?></span>
        </button>
	<?php endif; ?>

	<?php if ( $show_indicators !== false ) : ?>
        <div class="ym-gallery__indicators <?php echo $show_indicators ?>">
            <ol>
				<?php
				for ( $i = 0; $i < count( $reviews ); $i ++ ) :
					printf( '<li%s>', $i === 0 ? ' class="active"' : '' );
				endfor;
				?>
            </ol>
        </div>
	<?php endif; ?>
</div>