(function ($) {
    $.fn.extend({
        searchSuggestions: function (options) {
            options = $.extend({}, $.newSearchSuggestions.defaults, options);

            this.each(function () {
                new $.newSearchSuggestions($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });

    $.newSearchSuggestions = function (target, options) {
        this.target = target;
        this.options = options;
        this.timeout = null;
        this.results = [];

        this.reposition = function () {
            if (!this.options.parallax) {
                this.target.find('.banner-inner').css({marginTop: '', marginBottom: ''});
                this.target.find('.banner-content').css({opacity: ''});
                return;
            }

            var visible = $(window).scrollTop() < this.target.height();

            if (visible) {
                this.target.find('.banner-inner').css({
                    marginTop: $(window).scrollTop() / 2,
                    marginBottom: ($(window).scrollTop() / 2) * -1
                });
            }

            if (!this.options.relativeOpacity) {
                this.target.find('.banner-content').css({opacity: ''});
                return;
            }

            var invisiblePercentage = $(window).scrollTop() / this.target.height();
            if (this.options.relativeOpacity && invisiblePercentage < 0.9) {
                var opacity = Math.max(0, 1 - (invisiblePercentage * 1.5));
                this.target.find('.banner-content').css({opacity: opacity});
            }
        };

        $(window).on('resize orientationchange scroll scrollstart touchmove', $.proxy(this.reposition, this));

        this.reposition();

        this.watch('results', function () {
            if (this.results.length) {
                this.target.addClass('has-results');
            } else {
                this.target.removeClass('has-results');
            }
        });

        this.clearResults = function () {
            this.results = [];
            setTimeout($.proxy(this.updateResultList, this), 400);
        };

        this.updateResult = function (response) {
            if (response && response.length) {
                this.results = response;
                this.updateResultList();
            }
        };

        this.updateResultList = function () {
            if (!this.options.list) {
                this.options.list = $('<ul/>');
                this.target.append(this.options.list);
            }
            this.options.list.html('');
            $.each(this.results, this.createResultItem);
        };

        this.createResultItem = function (index, suggestion) {
            var anchor = $('<a/>');
            anchor.attr('href', suggestion.permalink);
            anchor.attr('title', suggestion.title);

            var highlightedText = suggestion.text;
            var terms = this.target.find('input').val().replace(/\s+/i, ' ').trim().split(' ');
            $.each(terms, function (index, term) {
                highlightedText = highlightedText.replace(new RegExp(term, 'gim'), '<strong>$&</strong>');
            });
            anchor.html(highlightedText);

            this.options.list.append($('<li/>').append(anchor));
        };

        this.loadSuggestions = function () {
            $.ajax({
                type: 'POST',
                url: ajaxurl,
                data: 's=' + this.target.serialize() + '&action=search_suggestions',
                dataType: 'json',
                beforeSend: this.clearResults,
                success: this.updateResult
            });
        };

        this.keyUp = function (e) {
            if (this.timeout) {
                clearTimeout(this.timeout);
            }
            if ($(e.target).val().replace(/\s+/i, ' ').trim().length > 1) {
                this.timeout = setTimeout($.proxy(this.loadSuggestions, this), 400);
            } else if (this.results.length) {
                this.clearResults();
            }
        };

        this.target.find('input').on('keyup', $.proxy(this.keyUp, this));
    };

    // option defaults
    $.newSearchSuggestions.defaults = {
        list: null
    };
})(jQuery);

$(function () {
    $('.search[show-suggestions]').searchSuggestions();
});