<?php

namespace yndenz\Modules\SearchSuggestions;

use yndenz\Modules\BaseModule\BaseModule;
use WP_Query;

class SearchSuggestions extends BaseModule {

    public static function register() {
        add_action('wp_ajax_nopriv_search_suggestions', array(static::class, 'getSuggestions'));
        add_action('wp_ajax_search_suggestions', array(static::class, 'getSuggestions'));
        add_filter('optionsframework_options_filter_search', array(static::class, 'registerSuggestions'));
    }

    /**
     * Get the scripts used for the banner.
     *
     * @return array
     */
    public static function getScripts() {
        return array(
            'search-suggestions-script' => array('src' => get_modules_directory_uri() . 'search-suggestions/search-suggestions.js')
        );
    }

    public static function registerSuggestions($options) {
        $options['search_suggestions'] = array(
            "name" => __('Suggesties', 'base-theme'),
            'desc' => __('Voer op elke regel een suggestie in, vervolgens de URL waar de suggestie heen moet navigeren, gescheiden met een \';\'. Deze suggesties worden weergegeven bij het invullen van het zoekveld, indien het thema dit ondersteunt.', 'base-theme'),
            "id" => "search_suggestions",
            'std' => '',
            "type" => "textarea");
        return $options;
    }

    /**
     * Get the search results for auto complete.
     */
    public static function getSuggestions() {
        $limit = 4;

        $args = wp_parse_args($_REQUEST, array(
            'post_status' => 'publish',
            'posts_per_page' => $limit,
            's' => ''
        ));

        $args = apply_filters('base_theme_basics_search_suggestions_args', $args);

        $output = static::searchSuggestions($args, $limit);

        if (count($output) >= $limit) {
            wp_send_json($output);
        }

        $search_terms = strtolower($args['s']);

        $search = new WP_Query($args);
        if ($search->have_posts()) {
            $output = array_merge($output, array_map(array(static::class, 'formatPost'), $search->posts, $search_terms));
        }

        wp_send_json(apply_filters('base_theme_basics_search_suggestions_result', $output));
    }

    /**
     * Format the result to be used in JavaScript.
     *
     * @param $result
     * @param $search_terms
     *
     * @return array
     */
    public static function formatPost($result, $search_terms) {
        $text = get_the_title($result);
        similar_text(strtolower($text), $search_terms, $similarity);

        return array(
            'permalink' => get_permalink($result),
            'title' => get_seo_title($result),
            'text' => $text,
            'similarity' => $similarity
        );
    }

    /**
     * If there is a FAQ, check the FAQ for answers first.
     *
     * @param $args
     * @param $limit
     *
     * @return array
     */
    public static function searchSuggestions(&$args, $limit) {
        $output = array();

        $suggestions = of_get_option('search_suggestions');
        if (empty($suggestions)) {
            return $output;
        }

        $lines = array_filter(preg_split('/((\r?\n)|(\r\n?))/', $suggestions));

        foreach ($lines as $line) {
            list($suggestion, $permalink) = explode(';', $line);

            if (!empty($suggestion) && !empty($permalink)) {
                similar_text(strtolower($suggestion), strtolower($args['s']), $similarity);

                array_push($output, array(
                    'permalink' => trim($permalink),
                    'title' => trim($suggestion),
                    'text' => trim($suggestion),
                    'similarity' => $similarity
                ));
            }
        }

        usort($output, function ($a, $b) {
            return $b['similarity'] - $a['similarity'];
        });

        if (count($output) > $limit) {
            return array_slice($output, 0, $limit);
        }

        $args['posts_per_page'] -= count($output);

        return $output;
    }

}