(function ($) {
    $.fn.extend({
        searchSuggestions: function (options) {
            options = $.extend({}, $.newSearchSuggestions.defaults, options);

            this.each(function () {
                new $.newSearchSuggestions($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });

    $.newSearchSuggestions = function (target, options) {
        this.target = target;
        this.options = options;
        this.timeout = null;
        this.results = [];

        this.watch('results', function (prop, oldVal, val) {
            if (val && val.length) {
                this.target.addClass('has-results');
            } else {
                this.target.removeClass('has-results');
            }

            return val;
        });

        this.clearResults = function () {
            this.results = [];
            setTimeout($.proxy(this.updateResultList, this), 400);
        };

        this.updateResult = function (response) {
            if (response && response.length) {
                this.results = response;
                this.updateResultList();
            }
        };

        this.updateResultList = function () {
            if (!this.options.list) {
                this.options.list = $('<ul/>').addClass('ym-search-suggestions');
                this.target.append(this.options.list);
            }
            this.options.list.html('');
            this.results.map($.proxy(this.createResultItem, this));
        };

        this.createResultItem = function (suggestion) {
            var anchor = $('<a/>');
            anchor.attr('href', suggestion.permalink);
            anchor.attr('title', suggestion.title);

            var highlightedText = suggestion.text;
            var terms = this.target.find('input').val().replace(/\s+/i, ' ').trim().split(' ');
            for (var i in terms) {
                highlightedText = highlightedText.replace(new RegExp(terms[i], 'gim'), '<strong>$&</strong>');
            }
            anchor.html(highlightedText);

            this.options.list.append($('<li/>').addClass('ym-search-suggestions__item').append(anchor));
        };

        this.loadSuggestions = function () {
            $.ajax({
                type: 'POST',
                url: ajaxurl,
                data: 's=' + this.target.serialize() + '&action=search_suggestions',
                dataType: 'json',
                context: this,
                beforeSend: this.clearResults,
                success: this.updateResult
            });
        };

        this.keyUp = function (e) {
            if (this.timeout) {
                clearTimeout(this.timeout);
            }
            if ($(e.target).val().replace(/\s+/i, ' ').trim().length > 1) {
                this.timeout = setTimeout($.proxy(this.loadSuggestions, this), 400);
            } else if (this.results.length) {
                this.clearResults();
            }
        };

        this.target.find('input').on('keyup', $.proxy(this.keyUp, this));
    };

    // option defaults
    $.newSearchSuggestions.defaults = {
        list: null
    };
})(jQuery);

$(function () {
    $('.search[show-suggestions]').searchSuggestions();
});