if (typeof yndenz === 'undefined') {
    var yndenz = yndenz || function () {
        return {};
    };
}

yndenz.modules = yndenz.modules || {};

yndenz.modules.searchSuggestions = yndenz.modules.searchSuggestions || {};

yndenz.modules.searchSuggestions.searchSuggestions = function (target, options) {
    this.target = target;
    this.options = options;
    this.timeout = null;
    this.results = [];

    this.watch('results', function (prop, oldVal, val) {
        if (val && val.length) {
            this.target.addClass('has-results');
        } else {
            this.target.removeClass('has-results');
        }

        return val;
    });

    this.target.find('input').on('keyup', jQuery.proxy(this.keyUp, this));
};

yndenz.modules.searchSuggestions.searchSuggestions.prototype.clearResults = function () {
    this.results = [];
    setTimeout(jQuery.proxy(this.updateResultList, this), 400);
};

yndenz.modules.searchSuggestions.searchSuggestions.prototype.updateResult = function (response) {
    if (response && response.length) {
        this.results = response;
        this.updateResultList();
    }
};

yndenz.modules.searchSuggestions.searchSuggestions.prototype.updateResultList = function () {
    if (!this.options.list) {
        this.options.list = jQuery('<ul/>').addClass('ym-search-suggestions');
        this.target.append(this.options.list);
    }
    this.options.list.html('');
    this.results.map(jQuery.proxy(this.createResultItem, this));
};

yndenz.modules.searchSuggestions.searchSuggestions.prototype.createResultItem = function (suggestion) {
    var anchor = jQuery('<a/>');
    anchor.attr('href', suggestion.permalink);
    anchor.attr('title', suggestion.title);

    var highlightedText = suggestion.text;
    var terms = this.target.find('input').val().replace(/\s+/i, ' ').trim().split(' ');
    for (var i in terms) {
        highlightedText = highlightedText.replace(new RegExp(terms[i], 'gim'), '<strong>$&</strong>');
    }
    anchor.html(highlightedText);

    this.options.list.append(jQuery('<li/>').addClass('ym-search-suggestions__item').append(anchor));
};

yndenz.modules.searchSuggestions.searchSuggestions.prototype.loadSuggestions = function () {
    jQuery.ajax({
        type: 'POST',
        url: ajaxurl,
        data: 's=' + this.target.serialize() + '&action=search_suggestions',
        dataType: 'json',
        context: this,
        beforeSend: this.clearResults,
        success: this.updateResult
    });
};

yndenz.modules.searchSuggestions.searchSuggestions.prototype.keyUp = function (e) {
    if (this.timeout) {
        clearTimeout(this.timeout);
    }
    if (jQuery(e.target).val().replace(/\s+/i, ' ').trim().length > 1) {
        this.timeout = setTimeout(jQuery.proxy(this.loadSuggestions, this), 400);
    } else if (this.results.length) {
        this.clearResults();
    }
};

yndenz.modules.searchSuggestions.searchSuggestions.defaults = {
    list: null
};

(function ($) {
    $.fn.extend({
        searchSuggestions: function (options) {
            options = $.extend({}, yndenz.modules.searchSuggestions.searchSuggestions.defaults, options);

            this.each(function () {
                new yndenz.modules.searchSuggestions.searchSuggestions($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });
})(jQuery);

jQuery(function () {
    jQuery('.search[show-suggestions]').searchSuggestions();
});