(function ($) {
    $.fn.extend({
        socialSideMenu: function (options) {
            options = $.extend({}, $.newSocialSideMenu.defaults, options);

            this.each(function () {
                new $.newSocialSideMenu($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });

    $.newSocialSideMenu = function (target, options) {
        this.target = target;
        this.options = options;
        this.timeout = null;

        this.fade = function () {
            if ($(window).scrollTop() < $('.full-screen-gallery').height() - this.target.offset().top - (this.target.height() / 2)) {
                this.target.addClass('faded');
            } else if (this.target.hasClass('faded')) {
                this.target.removeClass('faded');
            }
        };

        this.fadeTimeout = function (time) {
            if (!time) {
                time = 100;
            }

            if (this.timeout) {
                clearTimeout(this.timeout);
            }

            this.timeout = setTimeout(this.fade, time);
        };

        this.windowScroll = function () {
            var fullScreenGallery = $('.full-screen-gallery');
            if (fullScreenGallery.length) {
                fullScreenGallery.find('.item.active .image-wrapper img').on('load', $.proxy(this.fadeTimeout, this));
            } else {
                this.fade();
            }
        };
        $(window).on('resize orientationchange scroll scrollstart touchmove', $.proxy(this.windowScroll, this));

        this.fadeTimeout(100);
    };

    // option defaults
    $.newSocialSideMenu.defaults = {};
})(jQuery);

$(function () {
    $('.social-side-menu').socialSideMenu();
});