(function ($) {
    $.fn.extend({
        socialSideMenu: function (options) {
            options = $.extend({}, $.newSocialSideMenu.defaults, options);

            this.each(function () {
                new $.newSocialSideMenu($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });

    $.newSocialSideMenu = function (target, options) {
        this.target = target;
        this.options = options;
        this.timeout = null;
        this.faded = this.options.fadedWhen(this.target);

        this.changeFadedClass = function (faded) {
            if (faded) {
                this.target.addClass('faded');
            } else {
                this.target.removeClass('faded');
            }
        };

        this.watch('faded', function (prop, oldVal, val) {
            if (typeof oldVal === 'undefined') {
                this.changeFadedClass(val);
            } else {
                this.fadeTimeout();
            }
        });

        this.checkFade = function () {
            this.faded = this.options.fadedWhen(this.target);
        };

        this.fadeTimeout = function () {
            if (this.timeout) {
                clearTimeout(this.timeout);
            }

            this.timeout = setTimeout($.proxy(this.changeFadedClass, this), 100);
        };

        $(window).on('resize orientationchange scroll scrollstart touchmove', $.proxy(this.checkFade, this));

        setTimeout($.proxy(this.checkFade, this), 1000);
    };

    // option defaults
    $.newSocialSideMenu.defaults = {
        fadedWhen: function (target) {
            var fullScreenGallery = $('.ym-gallery.full-screen');
            if (fullScreenGallery.length) {
                return $(window).scrollTop() < 10 || $(window).scrollTop() < fullScreenGallery.offset().top + fullScreenGallery.height() - target.offset().top - (target.height() / 2);
            }

            return false;
        }
    };
})(jQuery);

$(function () {
    $('.ym-social-side-menu').socialSideMenu();
});