<?php

namespace yndenz\Modules\SocialSideMenu;

use yndenz\Modules\BaseModule\BaseModule;

class SocialSideMenu extends BaseModule {

    /**
     * Register a sidebar to completely customize the menu in WP Admin.
     */
    public static function register() {
        if (!function_exists('register_sidebar')) {
            return;
        }

        register_sidebar(array(
            'id' => 'social-sidebar',
            'name' => __('Social Media en contact', 'base-theme'),
            'description' => __('Deze widgets worden weergegeven aan de linker kant van het scherm.', 'base-theme'),
            'class' => '',
            'before_widget' => '<div class="widget">',
            'after_widget' => '</div>',
            'before_title' => '<h3>',
            'after_title' => '</h3>'
        ));
    }

    /**
     * Get the scripts used for the social side menu.
     *
     * @return array
     */
    public static function getScripts() {
        return array(
            'social-side-menu-script' => array('src' => get_modules_directory_uri() . 'social-side-menu/social-side-menu.js')
        );
    }

    /**
     * Display the social side menu.
     *
     * @param string $position
     */
    public function display($position = 'left') {
        $template = locate_template('modules/social-side-menu.php');
        if (empty($template)) {
            $template = dirname(__FILE__) . '/templates/social-side-menu.php';
        }

        include $template;
    }

}