if (typeof yndenz === 'undefined') {
    var yndenz = yndenz || function () {
        return {};
    };
}

yndenz.modules = yndenz.modules || {};

yndenz.modules.socialSideMenu = yndenz.modules.socialSideMenu || {};

yndenz.modules.socialSideMenu.socialSideMenu = function (target, options) {
    this.target = target;
    this.options = options;
    this.timeout = null;

    this.watch('faded', function (prop, oldVal, val) {
        if (typeof oldVal === 'undefined') {
            this.changeFadedClass(val);
        } else {
            this.fadeTimeout();
        }
    });

    jQuery(window).on('resize orientationchange scroll scrollstart touchmove', jQuery.proxy(this.checkFade, this));

    setTimeout(jQuery.proxy(this.checkFade, this), 10);
};

yndenz.modules.socialSideMenu.socialSideMenu.prototype.changeFadedClass = function (faded) {
    if (faded) {
        this.target.addClass('faded');
    } else {
        this.target.removeClass('faded');
    }
};

yndenz.modules.socialSideMenu.socialSideMenu.prototype.checkFade = function () {
    if (typeof this.options.fadedWhen === 'function') {
        this.faded = this.options.fadedWhen(this.target);
    } else if (typeof this.options.fadedWhen === 'string') {
        if (window[this.options.fadedWhen] && typeof window[this.options.fadedWhen] === 'function') {
            this.faded = window[this.options.fadedWhen](this.target);
        } else {
            this.faded = this.options.fadedWhen === 'true';
        }
    }
};

yndenz.modules.socialSideMenu.socialSideMenu.prototype.fadeTimeout = function () {
    if (this.timeout) {
        clearTimeout(this.timeout);
    }

    this.timeout = setTimeout(jQuery.proxy(this.changeFadedClass, this), 100);
};

yndenz.modules.socialSideMenu.socialSideMenu.defaults = {
    fadedWhen: function (target) {
        var fullScreenGallery = jQuery('.ym-gallery.full-screen');
        if (fullScreenGallery.length) {
            return jQuery(window).scrollTop() < fullScreenGallery.offset().top + fullScreenGallery.height() - target.offset().top - (target.height() / 2);
        }

        return false;
    }
};

(function ($) {
    $.fn.extend({
        socialSideMenu: function (options) {
            options = $.extend({}, yndenz.modules.socialSideMenu.socialSideMenu.defaults, options);

            this.each(function () {
                new yndenz.modules.socialSideMenu.socialSideMenu($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });
})(jQuery);

jQuery(function () {
    jQuery('.ym-social-side-menu').socialSideMenu();
});