(function ($) {
    $.fn.extend({
        subPage: function (options) {
            options = $.extend({}, $.newSubPage.defaults, options);

            this.each(function () {
                new $.newSubPage($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });

    $.newSubPage = function (target, options) {
        this.target = target;
        this.options = options;

        this.reposition = function () {
            if (!this.options.screenHeight || $(window).width() < 992 || this.height() > $(window).height()) {
                this.target.css({height: ''});
            } else {
                this.target.css({height: $(window).height()});
            }
        };

        $(window).on('resize orientationchange', this.reposition);

        this.reposition();
    };

    // option defaults
    $.newSubPage.defaults = {
        screenHeight: true
    };
})(jQuery);

$(function () {
    $('.sub-page-wrapper').subPage();
});