<?php

namespace yndenz\Modules\SubPages;

use yndenz\Modules\BaseModule\BaseModule;

class SubPages extends BaseModule {

    protected $pages = array();
    protected $num_pages;
    protected $initialized = false;

    public function __construct($num_pages = 5) {
        parent::__construct();

        $this->num_pages = $num_pages;
    }

    /**
     * Register subpages as custom fields.
     */
    public function register() {
        if (!function_exists("register_field_group")) {
            return;
        }

        $fields = array();
        for ($i = 1; $i <= $this->num_pages; $i++) {
            array_push($fields, array(
                'key' => "acf-subpage_{$i}_text",
                'label' => sprintf(__('Blok %d', 'base-theme'), $i),
                'name' => "subpage_{$i}_text",
                'type' => 'textarea',
                'default_value' => '',
                'placeholder' => '',
                'maxlength' => '',
                'rows' => '',
                'formatting' => 'html',
            ));
        }

        $fields = apply_filters('yndenz_modules_sub_pages_fields', $fields);

        $locations = array(
            array(
                array(
                    'param' => 'page_type',
                    'operator' => '==',
                    'value' => 'front_page',
                    'order_no' => 0,
                    'group_no' => 0,
                ),
            ),
        );

        $locations = apply_filters('yndenz_modules_sub_pages_locations', $locations);

        register_field_group(array(
            'id' => 'acf_subpages',
            'title' => __('Subpagina\'s', 'base-theme'),
            'fields' => $fields,
            'location' => $locations,
            'options' => array(
                'position' => 'normal',
                'layout' => 'no_box',
                'hide_on_screen' => array(),
            ),
            'menu_order' => 0,
        ));
    }

    /**
     * Get the scripts used for the sub-pages.
     *
     * @return array
     */
    public static function getScripts() {
        return array(
            'subpages-script' => array('src' => get_modules_directory_uri() . 'sub-pages/sub-pages.js')
        );
    }

    /**
     * Initialize the subpages content.
     */
    public function initialize() {
        for ($i = 1; $i <= $this->num_pages; $i++) {
            $content = get_post_meta(get_the_ID(), "subpage_{$i}_text", true);
            if (!empty($content)) {
                $content = apply_filters('the_content', $content);
                $content = preg_replace('~<h2>(.*)</h2>~i', '<header><h2>$1</h2></header>', $content);
                array_push($this->pages, $content);
            }
        }
        $this->initialized = true;
    }

    /**
     * Reset properties to be able to re-initialize.
     */
    public function reset() {
        $this->pages = array();
        $this->initialized = false;
    }

    /**
     * Display a listing of subpages.
     */
    public function display() {
        if (!$this->initialized) {
            $this->initialize();
        }

        $template = locate_template('modules/sub-pages.php');
        if (empty($template)) {
            $template = dirname(__FILE__) . '/templates/sub-pages.php';
        }

        foreach ($this->pages as $i => $content) :
            include $template;
        endforeach;
    }

}