<?php

namespace yndenz\Modules\SubPages;

use yndenz\Modules\BaseModule\BaseModule;

class SubPages extends BaseModule {

	protected $_pages = array();
	protected $_initialized = false;

	/**
	 * Register subpages as custom fields.
	 */
	public static function registerFields() {
		if ( ! function_exists( "register_field_group" ) ) {
			return;
		}

		$fields = array();
		for ( $i = 1; $i <= static::numPages(); $i ++ ) {
			array_push( $fields, array(
				'key'           => "field_subpage_{$i}_text",
				'label'         => sprintf( _x( 'Blok %d', 'Back-end pagina toevoegen/bewerken', 'base-theme' ), $i ),
				'name'          => "subpage_{$i}_text",
				'type'          => 'textarea',
				'default_value' => '',
				'placeholder'   => '',
				'maxlength'     => '',
				'rows'          => '',
				'formatting'    => 'html',
			) );
		}

		$fields = apply_filters( 'yndenz_modules_sub_pages_fields', $fields );

		$locations = array(
			array(
				array(
					'param'    => 'page_type',
					'operator' => '==',
					'value'    => 'front_page',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		);

		$locations = apply_filters( 'yndenz_modules_sub_pages_locations', $locations );

		register_field_group( array(
			'id'         => 'group_subpages',
			'title'      => _x( 'Subpagina\'s', 'Back-end pagina toevoegen/bewerken', 'base-theme' ),
			'fields'     => $fields,
			'location'   => $locations,
			'options'    => array(
				'position'       => 'normal',
				'layout'         => 'no_box',
				'hide_on_screen' => array(),
			),
			'menu_order' => 0,
		) );
	}

	public static function numPages() {
		return apply_filters( 'yndenz_modules_sub_pages_num_pages', 5 );
	}

	/**
	 * Reset properties to be able to re-initialize.
	 */
	public function reset() {
		$this->_pages       = array();
		$this->_initialized = false;
	}

	/**
	 * Display a listing of subpages.
	 */
	public function display() {
		if ( ! $this->_initialized ) {
			$this->initialize();
		}

		$template = locate_template( 'modules/sub-pages.php' );
		if ( empty( $template ) ) {
			$template = dirname( __FILE__ ) . '/templates/sub-pages.php';
		}

		foreach ( $this->_pages as $i => $content ) :
			include $template;
		endforeach;
	}

	/**
	 * Initialize the subpages content.
	 */
	public function initialize() {
		for ( $i = 1; $i <= static::numPages(); $i ++ ) {
			$content = get_post_meta( get_the_ID(), "subpage_{$i}_text", true );
			if ( ! empty( $content ) ) {
				$content = apply_filters( 'the_content', $content );
				$content = preg_replace( '~<h2>(.*)</h2>~i', '<header><h2>$1</h2></header>', $content );
				array_push( $this->_pages, $content );
			}
		}
		$this->_initialized = true;
	}

}