<?php

namespace yndenz\Modules\SubPages;

use yndenz\Modules\BaseModule\BaseModule;

class SubPages extends BaseModule {

	protected $_pages = array();
	protected $_initialized = false;

	/**
	 * Register subpages as custom fields.
	 */
	public static function registerFields() {
		if ( ! function_exists( "acf_add_local_field_group" ) ) {
			return;
		}

		static::registerSubPages();
	}

	public static function registerSubPages() {
		$fields = array();
		for ( $i = 1; $i <= static::numPages(); $i ++ ) {
			array_push( $fields, array(
				'key'        => "field_sub_page_{$i}_text",
				'label'      => sprintf( _x( 'Blok %d', 'Back-end pagina toevoegen/bewerken', 'base-theme' ), $i ),
				'name'       => "sub_page_{$i}_text",
				'type'       => 'textarea',
				'formatting' => 'html',
			) );
		}

		$fields = apply_filters( 'yndenz_modules_sub_pages_fields', $fields );

		$locations = array(
			array(
				array(
					'param'    => 'page_type',
					'operator' => '==',
					'value'    => 'front_page',
				),
			),
		);

		$locations = apply_filters( 'yndenz_modules_sub_pages_locations', $locations );

		acf_add_local_field_group( array(
			'id'       => 'group_sub_pages',
			'title'    => _x( 'Sub pagina\'s', 'Back-end pagina toevoegen/bewerken', 'base-theme' ),
			'fields'   => $fields,
			'location' => $locations,
			'position' => 'normal',
			'style'    => 'default',
		) );
	}

	public static function numPages() {
		return apply_filters( 'yndenz_modules_sub_pages_num_pages', 5 );
	}

	/**
	 * Reset properties to be able to re-initialize.
	 */
	public function reset() {
		$this->_pages       = array();
		$this->_initialized = false;
	}

	/**
	 * Display a listing of subpages.
	 */
	public function display() {
		if ( ! $this->_initialized ) {
			$this->initialize();
		}

		$template = locate_template( 'modules/sub-pages.php' );
		if ( empty( $template ) ) {
			$template = dirname( __FILE__ ) . '/templates/sub-pages.php';
		}

		foreach ( $this->_pages as $i => $content ) :
			include $template;
		endforeach;
	}

	/**
	 * Initialize the subpages content.
	 */
	public function initialize() {
		for ( $i = 1; $i <= static::numPages(); $i ++ ) {
			$content = get_post_meta( get_the_ID(), "sub_page_{$i}_text", true );
			if ( ! empty( $content ) ) {
				$content = apply_filters( 'the_content', $content );
				$content = preg_replace( '~<h2>(.*)</h2>~i', '<header><h2>$1</h2></header>', $content );
				array_push( $this->_pages, $content );
			}
		}
		$this->_initialized = true;
	}

}