(function ($) {
    $.fn.extend({
        swipeDetection: function (options) {
            options = $.extend({}, $.newSwipeDetection.defaults, options);

            this.each(function () {
                new $.newSwipeDetect($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });

    $.newSwipeDetection = function (target, options) {
        this.target = target;
        this.options = options;
        this.touchPosition = {x: 0, y: 0};

        this.touchStart = function (event) {
            var touchObject = event.originalEvent.touches[0] || event.originalEvent.changedTouches[0];
            this.touchPosition.x = touchObject.pageX;
            this.touchPosition.y = touchObject.pageY;
        };
        this.target.on('touchstart', $.proxy(this.touchStart, this));

        this.touchEnd = function (event) {
            var touchObject = event.originalEvent.touches[0] || event.originalEvent.changedTouches[0];
            var movement = {horizontal: touchObject.pageX - this.touchPosition.x, vertical: touchObject.pageY - this.touchPosition.y};
            var direction = '';
            if (Math.abs(movement.horizontal) >= this.options.threshold && Math.abs(movement.vertical) <= this.options.restraint) {
                direction = (movement.horizontal < 0) ? 'left' : 'right';
            }
            else if (Math.abs(movement.vertical) >= this.options.threshold && Math.abs(movement.horizontal) <= this.options.restraint) {
                direction = (movement.vertical < 0) ? 'up' : 'down';
            }
            this.options.callback(direction);
        };
        this.target.on('touchend', $.proxy(this.touchEnd, this));
    };

    // option defaults
    $.newSwipeDetection.defaults = {
        threshold: 150,
        restraint: 100,
        callback: function () {}
    };
})(jQuery);