if (typeof yndenz === 'undefined') {
    var yndenz = yndenz || function () {
        return {};
    };
}

yndenz.modules = yndenz.modules || {};

yndenz.modules.swipeDetection = yndenz.modules.swipeDetection || {};

yndenz.modules.swipeDetection.swipeDetection = function (target, options) {
    this.target = target;
    this.options = options;
    this.touchPosition = {x: 0, y: 0};

    this.target.on('touchstart', jQuery.proxy(this.touchStart, this));
    this.target.on('touchend', jQuery.proxy(this.touchEnd, this));
};

yndenz.modules.swipeDetection.swipeDetection.prototype.touchStart = function (event) {
    var touchObject = event.originalEvent.touches[0] || event.originalEvent.changedTouches[0];
    this.touchPosition.x = touchObject.pageX;
    this.touchPosition.y = touchObject.pageY;
};

yndenz.modules.swipeDetection.swipeDetection.prototype.touchEnd = function (event) {
    var touchObject = event.originalEvent.touches[0] || event.originalEvent.changedTouches[0];
    var movement = {
        horizontal: touchObject.pageX - this.touchPosition.x,
        vertical: touchObject.pageY - this.touchPosition.y
    };
    var direction = '';
    if (Math.abs(movement.horizontal) >= this.options.threshold && Math.abs(movement.vertical) <= this.options.restraint) {
        direction = (movement.horizontal < 0) ? 'left' : 'right';
    } else if (Math.abs(movement.vertical) >= this.options.threshold && Math.abs(movement.horizontal) <= this.options.restraint) {
        direction = (movement.vertical < 0) ? 'up' : 'down';
    }
    this.options.callback(direction);
};

yndenz.modules.swipeDetection.swipeDetection.defaults = {
    threshold: 150,
    restraint: 100,
    callback: function () {
    }
};

// Make touchstart event listener passive if possible
jQuery.event.special.touchstart = {
    setup: function (_, ns, handle) {
        if (ns.includes("noPreventDefault")) {
            this.addEventListener("touchstart", handle, {passive: false});
        } else {
            this.addEventListener("touchstart", handle, {passive: true});
        }
    }
};

(function ($) {
    $.fn.extend({
        swipeDetection: function (options) {
            options = $.extend({}, yndenz.modules.swipeDetection.swipeDetection.defaults, options);

            this.each(function () {
                new yndenz.modules.swipeDetection.swipeDetection($(this), $.extend({}, options, $(this).data()));
            });

            return this;
        }
    });
})(jQuery);