<?php

namespace yndenz\Modules\SwipeDetection;

use yndenz\Modules\BaseModule\BaseModule;

class SwipeDetection extends BaseModule {

	public static function init() {
		parent::init();
		add_filter( 'base_theme_basics_scripts', array( static::class, 'addScripts' ) );
	}

	/**
	 * Get the scripts used for the swipe detection.
	 *
	 * @return array
	 */
	public static function getScripts() {
		return array(
			'swipe-detection-script' => array( 'src' => get_modules_directory_uri() . 'swipe-detection/swipe-detection.js' )
		);
	}

}