<?php

namespace yndenz\Modules\ViewportToPixel;

use yndenz\Modules\BaseModule\BaseModule;

class ViewportToPixel extends BaseModule {

	public static function init() {
		parent::init();
		add_filter( 'base_theme_basics_scripts', array( static::class, 'addScripts' ) );
	}

	/**
	 * Get the viewport to pixel script.
	 *
	 * @return array
	 */
	public static function getScripts() {
		return array(
			'viewport-to-pixel' => array( 'src' => get_modules_directory_uri() . 'viewport-to-pixel/viewport-to-pixel.js' )
		);
	}

}