<?php

use yndenz\Modules\WebsiteOptimization\Functions;

if ( ! defined( 'OPTIMIZE_REMOVE_W3C_SLASHES' ) ) {
	define( "OPTIMIZE_REMOVE_W3C_SLASHES", true );
}
if ( ! defined( 'OPTIMIZE_ENVELOPE_FROM' ) ) {
	define( "OPTIMIZE_ENVELOPE_FROM", true );
}
if ( ! defined( 'OPTIMIZE_REMOVE_TYPE_ATTR' ) ) {
	define( "OPTIMIZE_REMOVE_TYPE_ATTR", true );
}
if ( ! defined( 'OPTIMIZE_REMOVE_JQUERY_MIGRATE' ) ) {
	define( "OPTIMIZE_REMOVE_JQUERY_MIGRATE", true );
}
if ( ! defined( 'OPTIMIZE_DEREGISTER_CF7_CSS' ) ) {
	define( "OPTIMIZE_DEREGISTER_CF7_CSS", true );
}
if ( ! defined( 'OPTIMIZE_DISABLE_CF7_REFILL' ) ) {
	define( "OPTIMIZE_DISABLE_CF7_REFILL", true );
}
if ( ! defined( 'OPTIMIZE_DISABLE_EMOJIS' ) ) {
	define( "OPTIMIZE_DISABLE_EMOJIS", true );
}
if ( ! defined( 'OPTIMIZE_REMOVE_GUTENBERG_CSS' ) ) {
	define( "OPTIMIZE_REMOVE_GUTENBERG_CSS", true );
}
if ( ! defined( 'OPTIMIZE_DEREGISTER_INLADEN_VAN_EMBED' ) ) {
	define( "OPTIMIZE_DEREGISTER_INLADEN_VAN_EMBED", true );
}
if ( ! defined( 'OPTIMIZE_DEFAULT_LAZY_LOADING_UIT' ) ) {
	define( "OPTIMIZE_DEFAULT_LAZY_LOADING_UIT", true );
}
if ( ! defined( 'OPTIMIZE_REMOVE_DEFAULT_WP_FAVICON' ) ) {
	define( "OPTIMIZE_REMOVE_DEFAULT_WP_FAVICON", true );
}
if ( ! defined( 'OPTIMIZE_HTML5_SUPPORT' ) ) {
	define( "OPTIMIZE_HTML5_SUPPORT", true );
}
if ( ! defined( 'OPTIMIZE_REMOVE_TYPE_SCRIPT' ) ) {
	define( "OPTIMIZE_REMOVE_TYPE_SCRIPT", true );
}
if ( ! defined( 'OPTIMIZE_REMOVE_USERS_WPJSON' ) ) {
	define( "OPTIMIZE_REMOVE_USERS_WPJSON", true );
}
if ( ! defined( 'OPTIMIZE_TOON_ADMINBAR_AAN_DE_ONDERKANT' ) ) {
	define( "OPTIMIZE_TOON_ADMINBAR_AAN_DE_ONDERKANT", true );
}
if ( ! defined( 'OPTIMIZE_TOON_TEMPLATE_IN_ADMIN_PAGES' ) ) {
	define( "OPTIMIZE_TOON_TEMPLATE_IN_ADMIN_PAGES", true );
}

////

if ( defined( 'OPTIMIZE_REMOVE_W3C_SLASHES' ) && OPTIMIZE_REMOVE_W3C_SLASHES ) {
	if ( class_exists( 'autoptimizeCache' ) ) {
		add_filter( 'autoptimize_html_after_minify', function ( $html ) {
			return str_replace( '/>', '>', $html );
		} );
	} else {
		add_action( 'wp_loaded', 'prefix_slash_output_buffer_start' );
		function prefix_slash_output_buffer_start() {
			ob_start( "prefix_slash_output_callback" );
		}

		function prefix_slash_output_callback( $buffer ) {
			return preg_replace( "%/>%", '>', $buffer );
		}

	}

}

if ( defined( 'OPTIMIZE_ENVELOPE_FROM' ) && OPTIMIZE_ENVELOPE_FROM ) {
	function phpmailer_envelope_from_fix( $phpmailer ) {
		$newFrom               = $phpmailer->From;
		$phpmailer->Sender     = $newFrom;
		$phpmailer->ReturnPath = $newFrom;
		$phpmailer->From       = $newFrom;
	}

	add_action( 'phpmailer_init', 'phpmailer_envelope_from_fix' );
}

if ( defined( 'OPTIMIZE_REMOVE_TYPE_ATTR' ) && OPTIMIZE_REMOVE_TYPE_ATTR ) {
	add_filter( 'style_loader_tag', 'codeless_remove_type_attr', 10, 1 );
	add_filter( 'script_loader_tag', 'codeless_remove_type_attr', 10, 1 );
	if ( class_exists( 'autoptimizeCache' ) ) {
		add_filter( 'autoptimize_html_after_minify', 'codeless_remove_type_attr', 10, 1 );
	} else {
		add_action( 'wp_loaded', 'prefix_output_buffer_start' );
		function prefix_output_buffer_start() {
			ob_start( "prefix_output_callback" );
		}

		function prefix_output_callback( $buffer ) {
			return preg_replace( "%[ ]type=[\'\"]text\/(javascript|css)[\'\"]%", '', $buffer );
		}

	}

	function codeless_remove_type_attr( $tag ) {
		return preg_replace( "/type=['\"]text\/(javascript|css)['\"]/", '', $tag );
	}
}

if ( defined( 'OPTIMIZE_REMOVE_JQUERY_MIGRATE' ) && OPTIMIZE_REMOVE_JQUERY_MIGRATE ) {
	add_action( 'wp_default_scripts', 'ps_remove_jquery_migrate' );

	function ps_remove_jquery_migrate() {
		if ( ! is_admin() && isset( $scripts->registered['jquery'] ) ) {
			$script = $scripts->registered['jquery'];
			if ( $script->deps ) {
				$script->deps = array_diff( $script->deps, array( 'jquery-migrate' ) );
			}
		}
	}
}
if ( defined( 'OPTIMIZE_DEREGISTER_CF7_CSS' ) && OPTIMIZE_DEREGISTER_CF7_CSS ) {
	add_filter( 'wpcf7_load_css', '__return_false' );
}
if ( defined( 'OPTIMIZE_DISABLE_CF7_REFILL' ) && OPTIMIZE_DISABLE_CF7_REFILL ) {
	add_action( 'wpcf7_enqueue_scripts', 'ps_disable_wpcf7_refill' );

	function ps_disable_wpcf7_refill() {
		global $wp_scripts;
		$handle      = 'contact-form-7';
		$object_name = 'wpcf7';
		$data        = $wp_scripts->get_data( $handle, 'data' );
		if ( ! empty( $data ) ) {
			if ( ! is_array( $data ) ) {
				$data = json_decode( str_replace( 'var ' . $object_name . ' = ', '', substr( $data, 0, - 1 ) ), true );
			}
			foreach ( $data as $key => $value ) {
				$localized_data[ $key ] = $value;
			}
			unset( $localized_data['cached'] );
			$wp_scripts->add_data( $handle, 'data', '' );
			wp_localize_script( $handle, $object_name, $localized_data );
		}
	}
}
if ( defined( 'OPTIMIZE_DISABLE_EMOJIS' ) && OPTIMIZE_DISABLE_EMOJIS ) {
	add_action( 'init', 'ps_disable_emojis' );

	function ps_disable_emojis() {
		remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
		remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
		remove_action( 'wp_print_styles', 'print_emoji_styles' );
		remove_action( 'admin_print_styles', 'print_emoji_styles' );
		remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
		remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );
		remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
		add_filter( 'tiny_mce_plugins', 'disable_emojis_tinymce' );

		return true;
	}
}
if ( defined( 'OPTIMIZE_REMOVE_GUTENBERG_CSS' ) && OPTIMIZE_REMOVE_GUTENBERG_CSS ) {
	// Disables the block editor from managing widgets in the Gutenberg plugin.
	add_filter( 'gutenberg_use_widgets_block_editor', '__return_false' );

	// Disables the block editor from managing widgets.
	add_filter( 'use_widgets_block_editor', '__return_false' );

	add_action( 'wp_enqueue_scripts', 'ps_remove_wp_block_library_css', 200 );

	function ps_remove_wp_block_library_css() {
		wp_dequeue_style( 'wp-block-library' );
		wp_dequeue_style( 'wp-block-library-theme' );
		wp_dequeue_style( 'wc-block-style' ); // Remove WooCommerce block CSS
	}
}

if ( defined( 'OPTIMIZE_DEREGISTER_INLADEN_VAN_EMBED' ) && OPTIMIZE_DEREGISTER_INLADEN_VAN_EMBED ) {
	add_action( 'wp_footer', 'ps_deregister_embed' );

	function ps_deregister_embed() {
		wp_deregister_script( 'wp-embed' );
	}
}
if ( defined( 'OPTIMIZE_DEFAULT_LAZY_LOADING_UIT' ) && OPTIMIZE_DEFAULT_LAZY_LOADING_UIT ) {
	add_filter( 'wp_lazy_loading_enabled', '__return_false' );
}
if ( defined( 'OPTIMIZE_REMOVE_DEFAULT_WP_FAVICON' ) && OPTIMIZE_REMOVE_DEFAULT_WP_FAVICON ) {
	add_action( 'do_faviconico', 'ps_favicon_remover' );

	function ps_favicon_remover() {
		exit;
	}
}
if ( defined( 'OPTIMIZE_HTML5_SUPPORT' ) && OPTIMIZE_HTML5_SUPPORT ) {
	add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption', 'style', 'script' ) );
}
if ( defined( 'OPTIMIZE_REMOVE_USERS_WPJSON' ) && OPTIMIZE_REMOVE_USERS_WPJSON ) {
	add_filter( 'rest_endpoints', function ( $endpoints ) {
		if ( isset( $endpoints['/wp/v2/users'] ) ) {
			unset( $endpoints['/wp/v2/users'] );
		}
		if ( isset( $endpoints['/wp/v2/users/(?P<id>[\d]+)'] ) ) {
			unset( $endpoints['/wp/v2/users/(?P<id>[\d]+)'] );
		}

		return $endpoints;
	} );
}
if ( defined( 'OPTIMIZE_TOON_ADMINBAR_AAN_DE_ONDERKANT' ) && OPTIMIZE_TOON_ADMINBAR_AAN_DE_ONDERKANT ) {
	add_action( 'wp_head', 'ps_move_admin_bar' );

	function ps_move_admin_bar() {
		echo '
			<style>
			html{margin-top:0 !important;}
			body.admin-bar #wphead {padding-top: 0;}
			body.admin-bar #footer {padding-bottom: 28px;}
			#wpadminbar { position: fixed; top: auto !important;bottom: 0;}
			#wpadminbar .ab-top-menu>.menupop>.ab-sub-wrapper{
				bottom: 28px;
			}
			</style>';
	}
}
if ( defined( 'OPTIMIZE_TOON_TEMPLATE_IN_ADMIN_PAGES' ) && OPTIMIZE_TOON_TEMPLATE_IN_ADMIN_PAGES ) {
	add_filter( 'manage_pages_columns', 'ps_table_columns', 10, 1 );
	add_action( 'manage_pages_custom_column', 'ps_table_column', 10, 2 );

	function ps_table_columns( $columns ) {
		$custom_columns = array(
			'ps_template' => 'Template'
		);

		$columns = array_merge( $columns, $custom_columns );

		return $columns;
	}
}