<?php

namespace yndenz\Modules\yndenzTotalCache;

use W3TC\Dispatcher;
use W3TC\PgCache_Plugin_Admin;
use W3TC\Util_Http;
use yndenz\Modules\BaseModule\BaseModule;
use yndenz\Modules\NoIndexSitemap\NoIndexSitemap;

class yndenzTotalCache extends BaseModule {

	protected $_config;

	public function __construct() {
		parent::__construct();
		$this->_config = Dispatcher::config();
	}

	public static function register() {
		add_action( 'w3_pgcache_prime', array( new static, 'prime' ) );
	}

	/**
	 * Prime page cache for pages with noindex.
	 *
	 * @param null|int      $start
	 * @param null|int      $limit
	 * @param null|callable $log_callback
	 */
	public function prime( $start = null, $limit = null, $log_callback = null ) {
		if ( is_null( $start ) ) {
			$start = get_option( 'w3tc_pgcache_prime_offset' );
		}
		if ( $start < 0 ) {
			$start = 0;
		}

		if ( is_null( $limit ) ) {
			$limit = $this->_config->get_integer( 'pgcache.prime.limit' );
		}
		if ( $limit < 1 ) {
			$limit = 1;
		}

		$sitemap = home_url( NoIndexSitemap::$name . '-sitemap.xml' );

		if ( ! is_null( $log_callback ) ) {
			$log_callback( 'Priming from sitemap ' . $sitemap .
			               ' entries ' . ( $start + 1 ) . '..' . ( $start + $limit ) );
		}

		/**
		 * Parse XML sitemap
		 */
		$old_error_level = error_reporting( 1 );
		$urls            = PgCache_Plugin_Admin::parse_sitemap( $sitemap );
		error_reporting( $old_error_level );

		// Stop here if the offset is higher than the amount of pages to be purged.
		if ( $start >= count( $urls ) ) {
			return;
		}

		/**
		 * Queue URLs
		 */
		$queue = array_slice( $urls, $start, $limit );

		/**
		 * Make HTTP requests and prime cache
		 */

		// use 'WordPress' since by default we use W3TC-powered by
		// which blocks caching
		foreach ( $queue as $url ) {
			Util_Http::get( $url, array( 'user-agent' => 'WordPress' ) );

			if ( ! is_null( $log_callback ) ) {
				$log_callback( 'Priming ' . $url );
			}
		}
	}
}
