<?php

if (!function_exists('register_subpages')) {
    add_action('init', 'register_subpages');
    function register_subpages()
    {
        if (function_exists("register_field_group")) {
            $fields = array();
            for ($i = 1; $i <= 5; $i++) {
                array_push($fields, array(
                    'key' => "acf-subpage_{$i}_text",
                    'label' => sprintf(__('Blok %d', 'base-theme'), $i),
                    'name' => "subpage_{$i}_text",
                    'type' => 'textarea',
                    'default_value' => '',
                    'placeholder' => '',
                    'maxlength' => '',
                    'rows' => '',
                    'formatting' => 'html',
                ));
            }
            register_field_group(array(
                'id' => 'acf_subpages',
                'title' => __('Subpagina\'s', 'base-theme'),
                'fields' => $fields,
                'location' => array(
                    array(
                        array(
                            'param' => 'page_type',
                            'operator' => '==',
                            'value' => 'front_page',
                            'order_no' => 0,
                            'group_no' => 0,
                        ),
                    ),
                ),
                'options' => array(
                    'position' => 'normal',
                    'layout' => 'no_box',
                    'hide_on_screen' => array(),
                ),
                'menu_order' => 0,
            ));
        }
    }
}

class SubPages
{

    private $pages = array();

    function __construct()
    {
        for ($i = 1; $i <= 5; $i++) {
            $content = get_post_meta(get_the_ID(), "subpage_{$i}_text", true);
            if (!empty($content)) {
                array_push($this->pages, apply_filters('the_content', $content));
            }
        }
    }

    function display()
    {
        foreach ($this->pages as $i => $content) :
            include(locate_template('module-subpages.php'));
        endforeach;
    }
}

if (!function_exists('enqueue_subpages_style_and_script')) {
    add_action('wp_enqueue_scripts', 'enqueue_subpages_style_and_script');
    function enqueue_subpages_style_and_script()
    {
        if (is_front_page()) {
            wp_register_script('subpages-script', get_template_directory_uri() . '/modules/subpages/subpages.js', array(), '1.0', true);
            wp_enqueue_script('subpages-script');
            wp_enqueue_style('subpages-style', get_template_directory_uri() . '/modules/subpages/subpages.css', array(), '1.0', 'all');
        }
    }
}