<?php
if (is_single() && in_category('nieuws')) {
    $action = 'link-to-page';
} else {
    $action = get_field('cta_action');
}

if (!empty($action) && $action !== 'null') : ?>
    <div class="call-to-action">
        <?php if ($action === 'link-to-page') :
            $cta_page_id = get_field('cta_page_id');
            if ((empty($cta_page_id) || $cta_page_id === 'null') && is_single() && in_category('nieuws')) {
                $cat = get_category_by_slug('nieuws');
                $category_link = get_category_link($cat->term_id);
                if (strstr($_SERVER['HTTP_REFERER'], $category_link) || preg_match('#/tag/#i', $_SERVER['HTTP_REFERER'])) {
                    $permalink = $_SERVER['HTTP_REFERER'];
                } else {
                    $permalink = $category_link;
                }
                $text = __('Terug naar overzicht', 'base-theme');
                $title = __('Terug naar overzicht | ' . get_bloginfo('name'), 'base-theme');
            } else {
                $permalink = get_permalink($cta_page_id);
                $text = get_field('cta_text');
                $title = get_field('cta_title');
            }
            ?>
            <a href="<?php echo $permalink; ?>"
               title="<?php echo $title; ?>" class="btn">
                <?php echo $text; ?>
            </a>
        <?php else : ?>
            <button type="button" class="btn" data-toggle="modal" data-target="#<?php echo $action; ?>-popup"
                    title="<?php echo get_field('cta_title'); ?>">
                <?php echo get_field('cta_text'); ?>
            </button>
        <?php endif; ?>
    </div>
<?php endif; ?>
