<?php get_header(); ?>

<?php
$title = null;
if (is_date()) {
    if (is_category('nieuws')) {
        $title = _e('Nieuws', 'base-theme') . single_month_title(' ', false);
    } else {
        $title = trim(single_month_title(' ', false));
    }
} else if (is_category()) {
    if (is_category('nieuws')) {
        $title = __('Laatste nieuws', 'base-theme');
    } else {
        $title = get_the_category();
    }
} else if (is_tag()) {
    $title = single_tag_title('', false);
}
$banner = new Banner($title);
$banner->display();
?>

    <div class="content">

        <?php get_template_part('partials/breadcrumb', 'cta-bar'); ?>

        <section role="main" class="container">
            <header>
                <h1 class="<?php echo $banner->includesTitle ? 'sr-only' : ''; ?>">
                    <?php echo $title; ?>
                </h1>
            </header>

            <?php if (is_category('nieuws') || is_tag()) : ?>
                <div class="filters">
                    <?php dynamic_sidebar('archive-news-sidebar'); ?>
                </div>
            <?php endif; ?>

            <?php if (function_exists('wp_pagenavi')) : ?>
                <div class="pagination-wrapper">
                    <?php wp_pagenavi(); ?>
                </div>
            <?php endif; ?>

            <?php get_template_part('loop'); ?>

            <?php if (function_exists('wp_pagenavi')) : ?>
                <div class="pagination-wrapper">
                    <?php wp_pagenavi(); ?>
                </div>
            <?php endif; ?>
        </section>

    </div>

<?php get_footer(); ?>