<?php
load_theme_textdomain('base-theme', get_stylesheet_directory() . '/languages');

include_once 'inc/theme_support.php';
include_once 'inc/menu.php';
include_once 'inc/sidebars.php';
include_once 'inc/scripts.php';

add_filter('auto_update_plugin', '__return_false');

if (!function_exists('force_logout_home')) {
    /**
     * Force redirect to base url after logout, because it'll redirect you to /wp-core/ by default, which will result in a 404.
     *
     * @return string
     */
    add_filter('logout_url', 'force_logout_home', 102, 2);
    function force_logout_home($logouturl)
    {
        $redir = 'http://www.' . $_SERVER['HTTP_HOST'] . '/';
        $logouturl = preg_replace('/&amp;redirect_to([^&]+)/', '&amp;redirect_to=' . urlencode($redir), $logouturl);
        return $logouturl;
    }
}

if (!function_exists('print_rr')) {
    /**
     * This custom version of print_r saves a lot of typing
     *
     * @param $var mixed the variable to display
     */
    function print_rr($var)
    {
        echo '<pre>';
        print_r($var);
        echo '</pre>';
    }
}

if (!function_exists('print_rr')) {
    /**
     * Check if the visitor is an yndenz employee
     *
     * @param $IP
     * @return bool
     */
    function is_yndenz($IP = '80.114.221.1')
    {
        return $_SERVER['REMOTE_ADDR'] === $IP;
    }
}

if (!function_exists('bootstrap_pagination')) {
    /**
     * Convert WP_PageNavi pagination to bootstrap pagination
     */
    add_filter('wp_pagenavi', 'bootstrap_pagination', 10, 2);
    function bootstrap_pagination($out)
    {
        $out = str_replace("<div class='wp-pagenavi'>", '<ul class="pagination">', $out);
        $out = str_replace("</div>", '</ul>', $out);
        $out = str_replace('<a', '<li><a', $out);
        $out = str_replace('</a>', '</a></li>', $out);
        $out = str_replace('<span', '<li><span', $out);
        $out = str_replace('</span>', '</span></li>', $out);
        return $out;
    }
}

if (!function_exists('wpcf7_custom_form_action_url')) {
    /**
     * Change Contact Form 7 action URL to homepage URL to prevent redirect and 404 errors on submitting forms in cars
     */
    add_filter('wpcf7_form_action_url', 'wpcf7_custom_form_action_url');
    function wpcf7_custom_form_action_url($url)
    {
        return site_url() . '/' . strstr($url, '#');
    }
}

if (!function_exists('disable_wp_emojicons')) {
	/**
	 * Disable emoji's
	 */
	add_action('init', 'disable_wp_emojicons');
	function disable_wp_emojicons() {
		// all actions related to emojis
		remove_action('admin_print_styles', 'print_emoji_styles');
		remove_action('wp_head', 'print_emoji_detection_script', 7);
		remove_action('admin_print_scripts', 'print_emoji_detection_script');
		remove_action('wp_print_styles', 'print_emoji_styles');
		remove_filter('wp_mail', 'wp_staticize_emoji_for_email');
		remove_filter('the_content_feed', 'wp_staticize_emoji');
		remove_filter('comment_text_rss', 'wp_staticize_emoji');
	}
}

if (!function_exists('remove_dns_prefetch')) {
	/**
	 * Remove the s.w.org dns prefetch that's only used for emoji's (which we don't allow anyway)
	 */
	add_filter('wp_resource_hints', 'remove_dns_prefetch', 10, 2);
	function remove_dns_prefetch($hints, $relation_type) {
		if ( 'dns-prefetch' === $relation_type ) {
			$matches = preg_grep('/emoji/', $hints);
			return array_diff( $hints, $matches );
		}

		return $hints;
	}
}

if (!function_exists('build_multipart_email_the_right_way')) {
    /**
     * Fixes the fact that Wordpress doesn't automatically add text/plain version to html e-mail
     * @param $phpmailer
     */
    add_action('phpmailer_init', 'build_multipart_email_the_right_way');
    function build_multipart_email_the_right_way($phpmailer)
    {
        $doc = new DOMDocument();
        $doc->loadHTML($phpmailer->Body);
        $xpath = new DOMXPath($doc);
        foreach ($xpath->query('//style') as $node) {
            $node->parentNode->removeChild($node);
        }
        $html = $doc->saveHTML();

        $phpmailer->AltBody = strip_tags($html);
    }
}

if (!function_exists('breadcrumb_microformats')) {
    /**
     * Convert yoast breadcrumbs to Microformatted breadcrumbs
     *
     * @param $breadcrumbs
     * @return mixed
     */
    add_filter('wpseo_breadcrumb_output', 'breadcrumb_microformats');
    function breadcrumb_microformats($breadcrumbs)
    {
        // Convert the breadcrumb to text without tags
        $breadcrumbs = strip_tags($breadcrumbs, '<a>');

        // Convert to array
        $separator = get_option('wpseo_internallinks')['breadcrumbs-sep'];
        $items = explode($separator, $breadcrumbs);

        // Create a breadcrumb list
        array_walk($items, function (&$item, $i) {
            $active = '';
            if (strstr($item, '<a')) {
                $seo_title = '';
                preg_match('~title="([^"]+)"~i', $item, $matches);
                if (count($matches)) {
                    $seo_title = $matches[1];
                } else {
                    preg_match('~href="([^"]+)"~i', $item, $matches);
                    if (count($matches)) {
                        $seo_title = get_seo_title(null, $matches[1]);
                    }
                }
                $item = preg_replace('/rel="v:url" property="v:title">([^<]+)</', 'itemprop="item" title="' . $seo_title . '"><span itemprop="name">$1</span><', $item);
            } else {
                $active = ' class="active"';
                $seo_title = wp_title('|', false);
                if (is_search()) {
                    $permalink = home_url('/') . '?s=';
                    $search_query = get_search_query();
                    if (!empty($search_query)) {
                        $permalink .= get_search_query();
                    } else {
                        $item = 'Zoeken';
                        $seo_title = preg_replace('~[^\|]+ \|~i', __('Zoeken', 'base-theme') . ' |', $seo_title);
                    }
                } else {
                    $permalink = get_permalink();
                }
                $item = sprintf('<a href="%s" itemprop="item" title="%s"><span itemprop="name">%s</span></a>', $permalink, $seo_title, trim($item));
            }
            $item = sprintf('<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem"%s>%s<meta itemprop="position" content="%d"/></li>', $active, trim($item), $i + 1);
        }, $items);
        return '<ol itemprop="breadcrumb" itemscope itemtype="http://schema.org/BreadcrumbList" class="breadcrumb">' . implode('', $items) . '</ol>';
    }
}

if (!function_exists('get_seo_meta')) {
    /**
     * Fetch the specific meta for a specific URL
     *
     * @param string $type The meta type to return, either 'title' or 'metadesc'
     * @param mixed $object The object to fetch the meta for
     * @param string $url The URL to fetch the meta for
     * @return mixed|string The yoast SEO meta or an empty string in case it could not be found
     */
    function get_seo_meta($type, $object = null, $url = null)
    {
        $short_type = str_replace('meta', '', $type);
        $seo_meta = '%%title%% %%sep%% %%sitename%%';
        if (method_exists('WPSEO_Options', 'get_options')) {
            $seo_options = WPSEO_Options::get_options(array('wpseo', 'wpseo_titles'));
        } else {
            $seo_options = WPSEO_Options::get_all();
        }
        $path = parse_url($url, PHP_URL_PATH);

        if (is_null($object) && is_null($url)) {
            $object = get_queried_object();
        } else if (is_null($object)) {
            if (trim($url, '/') . '/' === home_url('/')) {
                $object = get_post(get_option('page_on_front'));
            } else {
                $object = get_page_by_path($path, OBJECT, get_post_types());
            }
            if (!$object instanceof WP_Post && $path !== '/') {
                $slug = preg_replace('~.*/([^/]+)/?$~i', '$1', $path);
                $terms = get_terms(array('taxonomy' => get_taxonomies(), 'slug' => $slug, 'hide_empty' => false));
                if (is_array($terms) && count($terms) > 0) {
                    $object = $terms[0];
                }
            }
        }

        if ($object instanceof WP_Post) {
            if ($type === 'title') {
                $seo_frontend = WPSEO_Frontend::get_instance();
                $seo_meta = $seo_frontend->get_content_title($object);
            } else {
                if (array_key_exists($type . '-' . $object->post_type, $seo_options)) {
                    $seo_meta = $seo_options[$type . '-' . $object->post_type];
                }
            }
            if (empty($seo_meta)) {
                if (array_key_exists($type . '-' . get_post_type($object), $seo_options)) {
                    $seo_meta = $seo_options[$type . '-' . get_post_type($object)];
                }
            }
        } else if ($object instanceof WP_Term) {
            $seo_meta = '%%term_title%% %%page%% %%sep%% %%sitename%%';

            $meta = get_option('wpseo_taxonomy_meta');
            if ($meta && array_key_exists($object->taxonomy, $meta) && array_key_exists($object->term_id, $meta[$object->taxonomy]) && array_key_exists('wpseo_' . $short_type, $meta[$object->taxonomy][$object->term_id])) {
                $seo_meta = $meta[$object->taxonomy][$object->term_id]['wpseo_' . $short_type];
            } else if (array_key_exists($type . '-tax-' . $object->taxonomy, $seo_options)) {
                $seo_meta = $seo_options[$type . '-tax-' . $object->taxonomy];
            }
        } else {
            $post_types = get_post_types();
            foreach ($post_types as $post_type) {
                if ($url === get_post_type_archive_link($post_type)) {
                    if (array_key_exists($type . '-ptarchive-' . $post_type, $seo_options)) {
                        $seo_meta = $seo_options[$type . '-ptarchive-' . $post_type];
                    }
                }
            }
        }

        if (empty($object)) {
            $object = array();
        }

        $seo_meta = wpseo_replace_vars($seo_meta, $object);
        return apply_filters( 'wpseo_' . $type, $seo_meta );
    }
}

if (!function_exists('get_seo_title')) {
    /**
     * Fetch the title for a specific URL
     *
     * @param mixed $object The object to get the SEO title for
     * @param string $url The URL to fetch the SEO title for
     * @return mixed|string The yoast SEO title or an empty string in case it could not be found
     */
    function get_seo_title($object = null, $url = null)
    {
        return get_seo_meta('title', $object, $url);
    }
}

if (!function_exists('get_seo_description')) {
    /**
     * Fetch the SEO description for a specific URL
     *
     * @param mixed $object The object to get the SEO description for
     * @param string $url The URL to fetch the SEO description for
     * @return mixed|string The yoast SEO description or an empty string in case it could not be found
     */
    function get_seo_description($object = null, $url = null)
    {
        return get_seo_meta('metadesc', $object, $url);
    }
}

if (!function_exists('restructured_content')) {
    /**
     * Restructure content to include the correct microformats, HTML5-structure and styling classes
     *
     * @param bool $include_date
     * @param string $after_title
     */
    function restructured_content($include_date = false, $after_title = '')
    {
        global $post;

        $content = $post->post_content;
        if (preg_match('~<h1([^>]*)>(.*)</h1>~is', $post->post_content) <= 0) :
            $title = get_the_title();
            $content = "<h1>{$title}</h1>\r\n{$content}";
        endif;
        $content_filtered = apply_filters('the_content', $content);

        $page_header = '<header class="page-header">';
        $page_header .= '<h1 itemprop="name"$1>$2</h1>';
        if ($include_date) {
            $page_header .= '<time datetime="' . get_the_time('Y-m-d') . '" pubdate itemprop="datePublished" content="' . get_the_time('Y-m-d') . '">';
            $page_header .= get_the_date();
            $page_header .= '</time>';
            $page_header .= '<meta itemprop="dateModified" content="' . get_the_modified_time('Y-m-d') . '"/>';
        }
        $page_header .= $after_title;
        $page_header .= '</header>';

        $content_restructured = preg_replace('~<h1([^>]*)>(.*)</h1>~is', $page_header, $content_filtered);
        $content_restructured = preg_replace('/<p([^>]*)>/is', '<p itemprop="description"$1>', $content_restructured, 1);

        echo $content_restructured;
    }
}

if (!function_exists('search_auto_complete')) {
    add_action('wp_ajax_nopriv_search_auto_complete', 'search_auto_complete');
    add_action('wp_ajax_search_auto_complete', 'search_auto_complete');
    function search_auto_complete()
    {
        $limit = 4;
	    $output = array();

	    $args = wp_parse_args($_REQUEST, array(
		    'post_status' => 'publish',
		    'posts_per_page' => $limit,
		    's' => ''
	    ));

        $autocomplete_questions = of_get_option('autocomplete_questions');
        if (!empty($autocomplete_questions)) {
            $lines = array_filter(preg_split('/((\r?\n)|(\r\n?))/', $autocomplete_questions));

            foreach ($lines as $line) {
                list($question, $permalink) = explode(';', $line);

                if (!empty($question) && !empty($permalink)) {
                    similar_text(strtolower($question), strtolower($args['s']), $similarity);

                    array_push($output, array(
                        'permalink' => trim($permalink),
                        'title' => trim($question),
                        'text' => trim($question),
                        'similarity' => $similarity
                    ));
                }
            }

            usort($output, function ($a, $b) {
                return $b['similarity'] - $a['similarity'];
            });

            if (count($output) > $limit) {
                $output = array_slice($output, 0, $limit);
	            wp_send_json($output);
            }

            $args['posts_per_page'] -= count($output);
        }

        $search = new WP_Query($args);
        if ($search->have_posts()) {
            foreach ($search->posts as $result) {
                $text = get_the_title($result);
	            similar_text(strtolower($text), strtolower($args['s']), $similarity);

                array_push($output, array(
                    'permalink' => get_permalink($result),
                    'title' => get_post_meta($result->ID, '_yoast_wpseo_title', true),
                    'text' => $text,
                    'similarity' => $similarity
                ));
            }
        }

	    wp_send_json($output);
    }
}

if (!function_exists('add_title_to_attachments')) {
    /**
     * Add title attribute to images if it's not already there
     *
     * @param bool $include_date
     * @param string $after_title
     */
    add_filter('wp_get_attachment_image_attributes', 'add_title_to_attachments', 99, 2);
    function add_title_to_attachments($atts, $attachment)
    {
        if (!array_key_exists('title', $atts)) {
            if (array_key_exists('alt', $atts)) {
                $atts['title'] = $atts['alt'];
            } else {
                $atts['title'] = get_the_title($attachment);
            }
        }
        return $atts;
    }
}

if (!function_exists('read_more_button')) {
    add_shortcode('read_more_button', 'read_more_button');
    function read_more_button($args, $content)
    {
        $defaults = array(
            'href' => get_the_permalink(),
            'title' => get_post_meta(get_the_ID(), '_yoast_wpseo_title', true),
            'text' => __('Lees meer', 'base-theme') . ' &raquo;'
        );
        $defaults = apply_filters('default_read_more_button_args', $defaults);
        if (!empty($content)) {
            $defaults['text'] = $content;
        }
        $args = wp_parse_args($args, $defaults);

        ob_start();
        ?>
        <a href="<?php echo $args['href']; ?>" class="btn btn-link btn-read-more"
           title="<?php echo $args['title']; ?>">
            <?php echo $args['text']; ?>
        </a>
        <?php
        return ob_get_clean();
    }
}

if (!function_exists('display_image')) {
    add_shortcode('display_image', 'display_image');
    function display_image($atts)
    {
        $class = '';
        if (array_key_exists('class', $atts)) {
            $class = $atts['class'];
        }
        return wp_get_attachment_image($atts['id'], $atts['size'], false, array('class' => $class));
    }
}

/**
 * autoptimize_filter_css_replacetag: where in the HTML is optimized CSS injected
 *
 * @param array $location array containing the html-tag and the method (inject "before", "after" or "replace")
 * @return array with updated values
 */
add_filter('autoptimize_filter_css_replacetag', 'custom_autoptimize_css_location', 10, 1);
function custom_autoptimize_css_location($location)
{
    $location[0] = "</head>"; // tag
    $location[1] = "before"; // injection
    return $location;
}

if (!function_exists('register_recent_posts_widget')) {
    class recent_posts_widget extends WP_Widget
    {
        function __construct()
        {
            parent::__construct(
                'recent_posts_widget',
                __('Meest recente berichten (by yndenz)', 'base-theme'),
                array(
                    'description' => __('Een uitgebreide variant van de meest recente berichten widget.', 'base-theme')
                )
            );
        }

        public function widget($args, $instance)
        {
            $title = apply_filters('widget_title', $instance['title']);
            echo $args['before_widget'];
            if (!empty($title))
                echo $args['before_title'] . $title . $args['after_title'];

            $query_args = array(
                'post__not_in' => array(get_the_ID()),
                'posts_per_page' => 5,
                'post_type' => 'post',
                'post-status' => 'publish',
                'orderby' => 'date',
                'order' => 'DESC'
            );
            if (!empty($instance['category__in'])) {
                $query_args['category__in'] = explode(',', $instance['category__in']);
            }
            if (!empty($instance['numposts'])) {
                $query_args['posts_per_page'] = (int)$instance['numposts'];
            }

            query_posts($query_args);
            include locate_template('widget-recent-posts.php');
            wp_reset_query();
            wp_reset_postdata();

            echo $args['after_widget'];
        }

        public function form($instance)
        {
            $title = '';
            if (isset($instance['title'])) {
                $title = $instance['title'];
            }
            $numposts = '5';
            if (isset($instance['numposts'])) {
                $numposts = $instance['numposts'];
            }
            $categories = array();
            if (isset($instance['category__in'])) {
                $categories = explode(',', $instance['category__in']);
            }
            $show_thumbnail = '';
            if (isset($instance['show_thumbnail'])) {
                $show_thumbnail = $instance['show_thumbnail'];
            }
            $show_date = '';
            if (isset($instance['show_date'])) {
                $show_date = $instance['show_date'];
            }
            $show_excerpt = '';
            if (isset($instance['show_excerpt'])) {
                $show_excerpt = $instance['show_excerpt'];
            }
            $excerpt_length = '15';
            if (isset($instance['excerpt_length'])) {
                $excerpt_length = $instance['excerpt_length'];
            }
            ?>
            <p>
                <label for="<?php echo $this->get_field_id('title'); ?>">
                    <?php _e('Titel:', 'base-theme'); ?>
                </label>
                <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" type="text"
                       name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo esc_attr($title); ?>"/>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('numposts'); ?>">
                    <?php _e('Aantal berichten:', 'base-theme'); ?>
                </label>
                <input class="widefat" id="<?php echo $this->get_field_id('numposts'); ?>" type="text"
                       name="<?php echo $this->get_field_name('numposts'); ?>" value="<?php echo esc_attr($numposts); ?>"/>
            </p>
            <p>
                <label>
                    <?php _e('Categorie:', 'base-theme'); ?>
                </label><br/>
                <?php foreach (get_categories() as $category) : ?>
                    <input class="checkbox" type="checkbox"<?php echo in_array($category->term_id, $categories) ? ' checked' : ''; ?>
                           id="<?php echo $this->get_field_id('category__in'); ?>-<?php echo $category->term_id; ?>"
                           name="<?php echo $this->get_field_name('category__in'); ?>[<?php echo $category->term_id; ?>]"/>
                    <label for="<?php echo $this->get_field_id('category__in'); ?>">
                        <?php echo $category->name; ?>
                    </label><br/>
                <?php endforeach; ?>
            </p>
            <p>
                <input class="checkbox" id="<?php echo $this->get_field_id('show_thumbnail'); ?>" type="checkbox"
                       name="<?php echo $this->get_field_name('show_thumbnail'); ?>"<?php echo $show_thumbnail ? ' checked' : ''; ?>/>
                <label for="<?php echo $this->get_field_id('show_thumbnail'); ?>">
                    <?php _e('Afbeelding weergeven', 'base-theme'); ?>
                </label><br/>
                <input class="checkbox" id="<?php echo $this->get_field_id('show_date'); ?>" type="checkbox"
                       name="<?php echo $this->get_field_name('show_date'); ?>"<?php echo $show_date ? ' checked' : ''; ?>/>
                <label for="<?php echo $this->get_field_id('show_date'); ?>">
                    <?php _e('Datum weergeven', 'base-theme'); ?>
                </label><br/>
                <input class="widefat" id="<?php echo $this->get_field_id('show_excerpt'); ?>" type="checkbox"
                       name="<?php echo $this->get_field_name('show_excerpt'); ?>"<?php echo $show_excerpt === 1 ? ' checked' : ''; ?>/>
                <label for="<?php echo $this->get_field_id('show_excerpt'); ?>">
                    <?php _e('Samenvatting weergeven', 'base-theme'); ?>
                </label>
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('numposts'); ?>">
                    <?php _e('Aantal berichten:', 'base-theme'); ?>
                </label>
                <input class="widefat" id="<?php echo $this->get_field_id('excerpt_length'); ?>" type="text"
                       name="<?php echo $this->get_field_name('excerpt_length'); ?>" value="<?php echo esc_attr($excerpt_length); ?>"/>
            </p>
            <?php
        }

        public function update($new_instance, $old_instance)
        {
            $instance = array();
            $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
            $instance['category__in'] = (!empty($new_instance['category__in'])) ? implode(array_keys($new_instance['category__in'])) : '';
            $instance['numposts'] = (!empty($new_instance['numposts'])) ? strip_tags($new_instance['numposts']) : '5';
            $instance['show_thumbnail'] = (!empty($new_instance['show_thumbnail'])) ? 1 : 0;
            $instance['show_date'] = (!empty($new_instance['show_date'])) ? 1 : 0;
            $instance['show_excerpt'] = (!empty($new_instance['show_excerpt'])) ? 1 : 0;
            $instance['excerpt_length'] = (!empty($new_instance['excerpt_length'])) ? strip_tags($new_instance['numposts']) : '15';
            return $instance;
        }
    }

    function register_recent_posts_widget() {
        register_widget( 'recent_posts_widget' );
    }
    add_action( 'widgets_init', 'register_recent_posts_widget' );
}
