<?php

if (!function_exists('register_base_theme_menus')) {
    add_action('init', 'register_base_theme_menus');
    function register_base_theme_menus()
    {
        register_nav_menus(array(
            'header' => __('Header', 'base-theme'),
        ));
    }
}

/**
 * Class wp_include_non_clickables_navwalker
 *
 * A custom WordPress nav walker class to add the possibility of non-clickable links and shortcodes to menu items.
 */
class wp_include_non_clickables_navwalker extends Walker_Nav_Menu
{
    public function start_lvl(&$output, $depth = 0, $args = array())
    {
        $indent = str_repeat("\t", $depth);
        $output .= "\n$indent<ul role=\"menu\">\n";
    }

    public function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0)
    {
        $indent = ($depth) ? str_repeat("\t", $depth) : '';
        if (!in_array(parse_url($item->url, PHP_URL_HOST), [parse_url(home_url(), PHP_URL_HOST)])) {
            $item->target = '_blank';
        }
        $classes = empty($item->classes) ? array() : (array)$item->classes;
        $classes[] = 'menu-item-' . $item->ID;
        if (preg_match('~(https?://)?divider~i', $item->url)) {
            $classes[] = 'devider';
        }
        if (preg_match('~(https?://)?non\-clickable~i', $item->url)) {
            $classes[] = 'disabled';
        }
        if (substr($item->description, 0, 6) === 'image:') {
            $classes[] = 'margin-bottom-15';
        }
        $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args));
        $class_names = $class_names ? ' class="' . $class_names . '"' : '';
        $id = apply_filters('nav_menu_item_id', 'menu-item-' . $item->ID, $item, $args);
        $id = $id ? ' id="' . esc_attr($id) . '"' : '';
        $role = '';
        if (preg_match('~(https?://)?(non\-clickable|invisible|shortcode|divider)~i', $item->url)) {
            $role = ' role="presentation"';
        }
        $output .= $indent . '<li' . $id . $role . $class_names . '>';

        /**
         * Dividers, Shortcodes or Non-clickables
         * =============================
         * Determine whether the item is a Divider, Shortcode, Non-clickable or regular menu item.
         */
        if (preg_match('~(https?://)?(invisible|divider)~i', $item->url)) {
            $item_output = '';
        } else {
            $item_output = $args->before;
            if (preg_match('~(https?://)?non\-clickable~i', $item->url)) {
                $item_output .= '<span>';
                $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after;
                $item_output .= '</span>';
            } else {

                $atts = array();
                $atts['title'] = !empty($item->attr_title) ? $item->attr_title : '';
                $atts['target'] = !empty($item->target) ? $item->target : '';
                $atts['rel'] = !empty($item->xfn) ? $item->xfn : '';
                $atts['href'] = !empty($item->url) ? $item->url : '';

                if ($include_link = preg_match('/link\:\s*([^\s]+)\s*(.*)/i', $item->description, $matches)) {
                    $atts['href'] = $matches[1];
                    $item->description = $matches[2];
                }

                $atts = apply_filters('nav_menu_link_attributes', $atts, $item, $args);
                $attributes = '';
                foreach ($atts as $attr => $value) {
                    if (!empty($value)) {
                        $value = ('href' === $attr) ? esc_url($value) : esc_attr($value);
                        $attributes .= ' ' . $attr . '="' . $value . '"';
                    }
                }
                $custom_item_output = '<a' . $attributes . '>';
                $custom_item_output .= $args->link_before;
                if (preg_match('/image\:\s*(\d+)/i',$item->description, $matches)) {
                    $custom_item_output .= wp_get_attachment_image($matches[1], 'medium', false, array('class' => 'img-responsive'));
                } else {
                    $custom_item_output .= apply_filters('the_title', $item->title, $item->ID);
                }
                $custom_item_output .= $args->link_after;
                if (property_exists($item, 'link_extra_after')) {
                    $custom_item_output .= $item->link_extra_after;
                }
                $custom_item_output .= '</a>';

                $item_output .= $item->before;
                if (preg_match('~(https?://)?shortcode~i', $item->url)) {
                    if ($include_link) {
                        $item_output .= $custom_item_output;
                    }
                    $item_output .= apply_filters('the_content', $item->description);
                } else {
                    $item_output .= $custom_item_output;
                }
                $item_output .= $item->after;
            }
            $item_output .= $args->after;
        }
        $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
    }

    public function display_element($element, &$children_elements, $max_depth, $depth, $args, &$output)
    {
        if (!$element)
            return;
        $id_field = $this->db_fields['id'];
        // Display this element.
        if (is_object($args[0]))
            $args[0]->has_children = !empty($children_elements[$element->$id_field]);
        parent::display_element($element, $children_elements, $max_depth, $depth, $args, $output);
    }
}

/**
 * Class wp_bootstrap_navwalker
 *
 * A custom WordPress nav walker class to implement the Bootstrap 3 navigation style.
 */
class wp_bootstrap_navwalker extends wp_include_non_clickables_navwalker
{
    /**
     * @see Walker::start_lvl()
     * @since 3.0.0
     *
     * @param string $output Passed by reference. Used to append additional content.
     * @param int $depth Depth of page. Used for padding.
     * @param array $args
     */
    public function start_lvl(&$output, $depth = 0, $args = array())
    {
        $indent = str_repeat("\t", $depth);
        $output .= "\n$indent<ul role=\"menu\" class=\"dropdown-menu\"" . (isset($args->dropdown_id) && $args->dropdown_id ? ' id="' . $args->dropdown_id . '"' : '') . ">\n";
    }

    /**
     * @see Walker::start_el()
     * @since 3.0.0
     *
     * @param string $output Passed by reference. Used to append additional content.
     * @param object $item Menu item data object.
     * @param int $depth Depth of menu item. Used for padding.
     * @param array $args
     * @param int $id Menu item ID.
     */
    public function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0)
    {
        $classes = empty($item->classes) ? array() : (array)$item->classes;
        if ($args->has_children) {
            $classes[] = 'dropdown';
        }
        if (in_array('current-menu-item', $classes)) {
            $classes[] = 'active';
        }
        $item->classes = $classes;

        if ($args->has_children) {
            if ($depth > 0) {
                $dropdown_toggle_atts = ' class="submenu-toggle"';
            } else {
                $dropdown_toggle_atts = ' data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" class="dropdown-toggle"';
                if (isset($args->dropdown_id) && $args->dropdown_id) {
                    $dropdown_toggle_atts .= ' data-target="' . $args->dropdown_id . '"';
                }
            }
            if (!property_exists($item, 'link_extra_after')) {
                $item->link_extra_after = '';
            }
            $item->link_extra_after .= '</a> <a title="' . $item->attr_title . '" href="#"' . $dropdown_toggle_atts . '><span class="caret"></span>';
        }

        $item = apply_filters('wp_bootstrap_navwalker_item_args', $item, $depth, $args, $id);

        parent::start_el($output, $item, $depth, $args, $id);
    }
}

/**
 * Class seo_walker
 *
 * A custom WordPress walker class to add yoast titles to the links.
 */
class seo_walker extends Walker_Page
{
    public function start_lvl(&$output, $depth = 0, $args = array())
    {
        $indent = str_repeat("\t", $depth);
        $output .= "\n$indent<ul>\n";
    }

    function start_el(&$output, $page, $depth = 0, $args = array(), $current_page = 0)
    {
        parent::start_el($output, $page, $depth, $args, $current_page);
        $output = preg_replace('/href="(.+?)"([^>]*)>(.*)$/', 'href="$1" title="' . get_post_meta($page->ID, '_yoast_wpseo_title', true) . '"$2>$3', $output);
    }
}