// Hide Header on on scroll down
var didScroll, lastScrollTop = 0, delta = 5, navbarHeight, bodyHeader, scrollCheckInterval;

window.hasScrolled = function () {
    var st = $(this).scrollTop();

    // Make sure they scroll more than delta
    if (Math.abs(lastScrollTop - st) <= delta)
        return;

    // Force the header down when the navigation is open
    if ($(window).width() < window.gridFloatBreakpoint && bodyHeader.find('.navbar-collapse').hasClass('in')) {
        bodyHeader.removeClass('nav-up').addClass('nav-down');
        return;
    }

    // If they scrolled down and are past the navbar, add class .nav-up.
    // This is necessary so you never see what is "behind" the navbar.
    if (st > lastScrollTop && st > navbarHeight) {
        // Scroll Down
        bodyHeader.removeClass('nav-down').addClass('nav-up');
    } else {
        // Scroll Up
        if (st + $(window).height() < $(document).height()) {
            bodyHeader.removeClass('nav-up').addClass('nav-down');
        }
    }

    lastScrollTop = st;
};

window.navigationEffects = function () {
    $(document).on('mouseenter', '.navbar .dropdown', function () {
        if ($(window).width() >= window.gridFloatBreakpoint) {
            $(this).addClass('open');
        }
    });
    $(document).on('mouseleave', '.navbar .dropdown', function () {
        if ($(window).width() >= window.gridFloatBreakpoint) {
            $(this).removeClass('open');
        }
    });

    $(document).on('click', '.submenu-toggle', function (e) {
        e.preventDefault();
        e.stopPropagation();
        $(this).parent().toggleClass('open');
    });
};

$(function () {
    bodyHeader = $('body > header');
    navbarHeight = bodyHeader.find('.navbar-header').outerHeight();

    bodyHeader.find('.navbar-header .toggle-button').on('click', function () {
        setTimeout(window.hasScrolled, 600);
    });

    $(window).on('scroll scrollstart touchmove', function () {
        didScroll = true;
    });

    if (scrollCheckInterval) {
        clearInterval(scrollCheckInterval);
    }
    scrollCheckInterval = setInterval(function () {
        if (didScroll) {
            window.hasScrolled();
            didScroll = false;
        }
    }, 100);

    window.navigationEffects();
});