<?php

if (!function_exists('enqueue_library_styles_and_scripts')) {
    add_action('wp_enqueue_scripts', 'enqueue_library_styles_and_scripts');
    function enqueue_library_styles_and_scripts()
    {
        if (!is_admin()) {
            // Replace the default jQuery with a placeholder and use the latest jquery (conditionally enqueued in header, because of browser compatibility)
            wp_deregister_script('jquery');
            wp_register_script('jquery', get_template_directory_uri() . '/js/jquery-placeholder.js', array(), '', true);
            wp_enqueue_script('jquery');

            wp_deregister_script('jquery-ui-core');
            wp_register_script('jquery-ui-core', get_template_directory_uri() . '/bower_components/jquery-ui/jquery-ui.min.js', array(), '1.11.4', true);
            wp_enqueue_script('jquery-ui-core');
            wp_register_script('jquery-ui-regional-nl', get_template_directory_uri() . '/bower_components/jquery-ui/ui/i18n/datepicker-nl.js', array('jquery-ui-core'), '1.11.4', true);
            wp_enqueue_script('jquery-ui-regional-nl');
        }

        // include library scripts
        wp_register_script('bootstrap', get_template_directory_uri() . '/bower_components/bootstrap-sass/assets/javascripts/bootstrap.min.js', array(), '3.3.5', true);
        wp_enqueue_script('bootstrap');

        wp_register_script('fancybox', get_template_directory_uri() . '/bower_components/fancybox/source/jquery.fancybox.pack.js', array(), '2.1.5', true);
        wp_enqueue_script('fancybox');
        wp_enqueue_style('fancybox-style', get_template_directory_uri() . '/bower_components/fancybox/source/jquery.fancybox.css', array(), '2.1.5', 'all');

        wp_register_script('jquery_lazyload', get_template_directory_uri() . '/bower_components/jquery_lazyload/jquery.lazyload.js', array(), '1.9.7', true);
        wp_enqueue_script('jquery_lazyload');

        wp_register_script('jq-dropdown-script', get_template_directory_uri() . '/bower_components/jq-dropdown/jquery.dropdown.js', array('bootstrap'), false, true);
        wp_enqueue_script('jq-dropdown-script');
        wp_enqueue_style('jq-dropdown-styles', get_template_directory_uri() . '/bower_components/jq-dropdown/jquery.dropdown.css', array(), false, 'all');
    }
}

if (!function_exists('enqueue_base_styles_and_scripts')) {
    add_action('wp_enqueue_scripts', 'enqueue_base_styles_and_scripts');
    function enqueue_base_styles_and_scripts()
    {
        // custom scripts
        wp_register_script('search-script', get_template_directory_uri() . '/js/search.js', array(), '1.0', true);
        wp_enqueue_script('search-script');
        wp_register_script('base-header-script', get_template_directory_uri() . '/js/header.js', array(), '1.0', true);
        wp_enqueue_script('base-header-script');
        wp_register_script('main-script', get_template_directory_uri() . '/js/main.js', array(), '1.0', true);
        wp_enqueue_script('main-script');

        // custom styles
        wp_enqueue_style('base-fonts', get_template_directory_uri() . '/style/fonts.css', array(), '1.0', 'all');
        // in this case (custom bootstrap) stylesheet directory because this one is 99% of the times customised in child themes
        wp_enqueue_style('custom-bootstrap-style', get_stylesheet_directory_uri() . '/style/custom-bootstrap.css', array(), '1.0', 'all');
        wp_enqueue_style('base-style', get_template_directory_uri() . '/style.css', array(), '1.0', 'all');
    }
}
