var homepageSlider, homepageSliderHolder;

window.responsiveHomepageSlider = function () {
    $.event.trigger({
        type: 'beforeResponsiveHomepageSlider'
    });

    var sliderImages = homepageSlider.find('.item .image-wrapper img');
    var activeImage = homepageSlider.find('.item.active .image-wrapper img');

    if ($(window).width() < 768) {
        homepageSlider.css({paddingTop: $('body > header').height()});
    } else if ($(window).width() < 992) {
        homepageSlider.css({paddingTop: 50});
    } else {
        homepageSlider.css({paddingTop: ''});
    }

    if ($(window).width() >= 992) {
        homepageSlider.css({height: $(window).height(), width: $(window).width()}).addClass('position-fixed');

        var activeImageRatio = activeImage.width() / activeImage.height();
        var containerRatio = $(window).width() / $(window).height();
        if (activeImageRatio < containerRatio) {
            sliderImages.css({
                height: '',
                width: $(window).width()
            });
        } else {
            sliderImages.css({
                height: homepageSlider.height(),
                width: ''
            });
        }
        homepageSliderHolder.css({height: homepageSlider.outerHeight()});
    } else {
        homepageSliderHolder.css({height: homepageSlider.outerHeight()});
        sliderImages.css({height: '', width: ''});
        homepageSlider.css({height: '', width: ''}).addClass('position-fixed');
    }

    $.event.trigger({
        type: 'afterResponsiveHomepageSlider'
    });
};

window.swipedetect = function (el, callback) {
    $.event.trigger({
        type: 'beforeSwipedetect',
        el: el,
        callback: callback
    });

    var touchsurface = el,
        swipedir,
        startX,
        startY,
        distX,
        distY,
        threshold = 150, //required min distance traveled to be considered swipe
        restraint = 100, // maximum distance allowed at the same time in perpendicular direction
        startTime,
        handleswipe = callback || function (swipedir) {
            };

    touchsurface.on('touchstart', function (e) {
        var touchobj = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];
        swipedir = 'none';
        distX = 0;
        distY = 0;
        startX = touchobj.pageX;
        startY = touchobj.pageY;
        startTime = new Date().getTime(); // record time when finger first makes contact with surface
    });

    touchsurface.on('touchend', function (e) {
        var touchobj = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];
        distX = touchobj.pageX - startX; // get horizontal dist traveled by finger while in contact with surface
        distY = touchobj.pageY - startY; // get vertical dist traveled by finger while in contact with surface
        if (Math.abs(distX) >= threshold && Math.abs(distY) <= restraint) { // 2nd condition for horizontal swipe met
            swipedir = (distX < 0) ? 'left' : 'right'; // if dist traveled is negative, it indicates left swipe
        }
        else if (Math.abs(distY) >= threshold && Math.abs(distX) <= restraint) { // 2nd condition for vertical swipe met
            swipedir = (distY < 0) ? 'up' : 'down'; // if dist traveled is negative, it indicates up swipe
        }
        handleswipe(swipedir);
    });

    $.event.trigger({
        type: 'afterSwipedetect',
        el: el,
        callback: callback
    });
};

$(function () {
    homepageSlider = $('#homepage-slider');
    homepageSliderHolder = $('#homepage-slider-holder');
    if (homepageSlider.length) {
        $(window).on('resize orientationchange', function () {
            window.responsiveHomepageSlider();
            setTimeout(window.responsiveHomepageSlider, 700);
        });

        homepageSlider.find('.item.active .image-wrapper img').on('load', window.responsiveHomepageSlider);

        window.responsiveHomepageSlider();
        setTimeout(window.responsiveHomepageSlider, 1000);

        window.swipedetect(homepageSlider, function (swipedir) {
            if (swipedir == 'left') {
                homepageSlider.carousel('prev');
            } else if (swipedir == 'right') {
                homepageSlider.carousel('next');
            }
        });
    }
});