var homepageSlider, socialSideMenu, socialSideMenuTimeoutPromise;

window.fadeSocialSideMenu = function () {
    $.event.trigger({
        type: 'beforeFadeSocialSideMenu'
    });

    if ($(window).scrollTop() < homepageSlider.height() - socialSideMenu.offset().top - (socialSideMenu.height() / 2)) {
        socialSideMenu.addClass('faded');
    } else if (socialSideMenu.hasClass('faded')) {
        socialSideMenu.removeClass('faded');
    }

    $.event.trigger({
        type: 'afterFadeSocialSideMenu'
    });
};

$(function () {
    socialSideMenu = $('#social-sidemenu');
    if (socialSideMenu.length) {
        $(window).on('resize orientationchange scroll scrollstart touchmove', fadeSocialSideMenu);

        homepageSlider = $('#homepage-slider');
        if (homepageSlider.length) {
            homepageSlider.find('.item.active .image-wrapper img').on('load', function () {
                clearTimeout(socialSideMenuTimeoutPromise);
                socialSideMenuTimeoutPromise = setTimeout(window.fadeSocialSideMenu, 100);
            });
        } else {
            window.fadeSocialSideMenu();
        }

        socialSideMenuTimeoutPromise = setTimeout(window.fadeSocialSideMenu, 1000);
    }
});