<?php
$slides = new WP_Query(array(
    'post_type' => 'slide',
    'posts_per_page' => -1,
    'orderby' => 'menu_order'
));
if ($slides->have_posts()) : ?>
    <div id="homepage-slider-holder"></div>
    <div id="homepage-slider" role="banner">
        <div class="carousel slide" data-ride="carousel">
            <div class="carousel-inner" role="listbox">
                <?php $active = true;
                while ($slides->have_posts()) : $slides->the_post(); ?>
                    <div class="item<?php echo $active ? ' active' : ''; ?>">
                        <div class="image-wrapper">
                            <?php the_post_thumbnail('full', array('class' => 'img-responsive lazy')); ?>
                            <noscript>
                                <?php the_post_thumbnail('full', array('class' => 'img-responsive')); ?>
                            </noscript>
                        </div>
                        <div class="container">
                            <div class="carousel-caption">
                                <div class="carousel-inner-block">
                                    <?php the_content(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php $active = false;
                endwhile; ?>
            </div>

            <div class="carousel-indicators-wrapper">
                <ol class="carousel-indicators">
                    <?php for ($i = 0; $i < $slides->post_count; $i++) : ?>
                        <li data-target="#homepage-slider .carousel"
                            data-slide-to="<?php echo $i; ?>"<?php echo $i === 0 ? ' class="active"' : ''; ?>>
                        </li>
                    <?php endfor; ?>
                </ol>
            </div>
        </div>
    </div>
    <?php
    wp_reset_postdata();
endif;
?>