var searchTimeout, searchResultsFor, searchResults;

if (!window.autoCompleteSearch) {
    window.autoCompleteSearch = function () {
        $.event.trigger({
            type: 'beforeAutoCompleteSearch'
        });

        $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: 's=' + searchResultsFor.serialize() + '&action=search_auto_complete',
            dataType: 'json',
            beforeSend: function () {
                searchResultsFor.removeClass('has-results');
            },
            success: window.autoCompleteSearchProcessResponse
        });

        $.event.trigger({
            type: 'afterAutoCompleteSearch'
        });
    };
}

if (!window.autoCompleteSearchProcessResponse) {
    window.autoCompleteSearchProcessResponse = function (response) {
        $.event.trigger({
            type: 'beforeAutoCompleteSearchProcessResponse',
            response: response
        });

        if (!searchResults || !searchResults.length) {
            searchResults = $('<ul/>');
            searchResultsFor.append(searchResults);
        }

        searchResults.find('li').remove();
        if (response && response.length) {
            $.each(response, window.autoCompleteSearchSetItem);
            searchResultsFor.addClass('has-results');
        }

        $.event.trigger({
            type: 'afterAutoCompleteSearchProcessResponse',
            response: response
        });
    };
}

if (!window.autoCompleteSearchSetItem) {
    window.autoCompleteSearchSetItem = function(index, result) {
        $.event.trigger({
            type: 'beforeAutoCompleteSearchSetItem',
            index: index,
            result: result
        });

        var anchor = $('<a/>');
        anchor.attr('href', result.permalink);
        anchor.attr('title', result.title);

        var highlightedText = result.text;
        var terms = searchResultsFor.find('input').val().replace(/\s+/i, ' ').trim().split(' ');
        $.each(terms, function (index, term) {
            highlightedText = highlightedText.replace(new RegExp(term, 'gim'), '<strong>$&</strong>');
        });
        anchor.html(highlightedText);

        searchResults.append($('<li/>').append(anchor));

        $.event.trigger({
            type: 'afterAutoCompleteSearchSetItem',
            index: index,
            result: result
        });
    };
}

$(function () {
    if ($('form.search').length) {
        $('form.search input').on('keyup', function () {
            if (searchTimeout) {
                clearTimeout(searchTimeout);
            }
            searchResultsFor = $(this).parents('form.search');
            if ($(this).val().replace(/\s+/i, ' ').trim().length > 1) {
                searchTimeout = setTimeout(window.autoCompleteSearch, 400);
            } else if (searchResultsFor.hasClass('has-results')) {
                searchResultsFor.removeClass('has-results');
                setTimeout(function () {
                    searchResults.find('li').remove();
                }, 400);
            }
        });
    }
});