<div class="list-employees">
    <?php
    $employees = new WP_Query(array(
        'posts_per_page' => -1,
        'ignore_sticky_posts' => true,
        'post_type' => 'employee',
        'orderby' => 'menu_order'
    ));
    while ($employees->have_posts()) :
        $employees->the_post();
        $team_page_image_id = get_field('team_page_image');
        if (empty($team_page_image_id)) {
            $team_page_image_id = get_post_thumbnail_id();
        }
        $metadata = wp_get_attachment_metadata($team_page_image_id);
        ?>
        <div class="specialist" itemprop="author" itemscope itemtype="http://schema.org/Person">
            <div class="container">
                <div class="row">
                    <div class="col-xs-8 col-xs-offset-2 col-sm-6 col-sm-offset-0 col-md-5 col-md-offset-1 col-lg-5 col-lg-offset-1" itemprop="image" itemscope itemtype="http://schema.org/ImageObject">
                        <meta itemprop="width" content="<?php echo $metadata['width']; ?>"/>
                        <meta itemprop="height" content="<?php echo $metadata['height']; ?>"/>
                        <?php echo wp_get_attachment_image($team_page_image_id, 'large', false, array('class' => 'img-responsive', 'itemprop' => 'url')); ?>
                    </div>
                    <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">
                        <?php the_content(); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endwhile; ?>
</div>
