<?php

if (!function_exists('register_banner')) {
    add_action('init', 'register_banner');
    function register_banner()
    {
    	$locations = array(
		    array(
			    array(
				    'param' => 'post_type',
				    'operator' => '==',
				    'value' => 'page',
				    'order_no' => 0,
				    'group_no' => 0,
			    ),
			    array(
				    'param' => 'page_type',
				    'operator' => '!=',
				    'value' => 'front_page',
				    'order_no' => 1,
				    'group_no' => 0,
			    ),
		    ),
		    array(
			    array(
				    'param' => 'post_type',
				    'operator' => '==',
				    'value' => 'post',
				    'order_no' => 0,
				    'group_no' => 1,
			    ),
		    ),
		    array(
			    array(
				    'param' => 'ef_taxonomy',
				    'operator' => '==',
				    'value' => 'category',
				    'order_no' => 0,
				    'group_no' => 2,
			    ),
		    ),
		    array(
			    array(
				    'param' => 'ef_taxonomy',
				    'operator' => '==',
				    'value' => 'post_tag',
				    'order_no' => 0,
				    'group_no' => 3,
			    ),
		    ),
	    );
	    $locations = apply_filters('module_banner_locations', $locations);

	    $fields = array(
            array(
                'key' => 'acf_banner-image',
                'label' => __('Banner afbeelding', 'base-theme'),
                'name' => 'banner_image',
                'type' => 'image',
                'save_format' => 'id',
                'preview_size' => 'medium',
                'library' => 'all',
            ),
            array(
                'key' => 'acf_banner-content',
                'label' => __('Banner content', 'base-theme'),
                'name' => 'banner_content',
                'type' => 'textarea',
                'default_value' => '',
                'placeholder' => '',
                'maxlength' => '',
                'rows' => '',
                'formatting' => 'none',
            ),
        );
	    $fields = apply_filters('module_banner_fields', $fields);

        if (function_exists('register_field_group')) {
            register_field_group(array(
                'id' => 'acf_banner',
                'title' => __('Banner', 'base-theme'),
                'fields' => $fields,
                'location' => $locations,
                'options' => array(
                    'position' => 'acf_after_title',
                    'layout' => 'default',
                    'hide_on_screen' => array(),
                ),
                'menu_order' => 0,
            ));
        }
    }
}

class Banner
{

    private $image = null;
    private $image_size = 'full';
    private $content = '';
    public $includesTitle = false;

    function __construct($title = null, $image_size = 'full')
    {
        $this->image_size = $image_size;

        global $post;
        $content = '';
        if (is_search() && is_main_query() && !in_the_loop()) {
            $this->image = of_get_option('search_banner');
        } else if (is_404()) {
            $this->image = of_get_option('404_page_banner');
        } else if (is_tag() && is_main_query() && !in_the_loop()) {
            $tag = get_tag(get_query_var('tag_id'));
            $this->image = get_field('banner_image', "{$tag->taxonomy}_{$tag->term_id}");
            if (empty($this->image)) {
                $this->image = of_get_option('default_tag_banner');
            }
            $content = get_field('banner_content', "{$tag->taxonomy}_{$tag->term_id}");
            if (empty($content)) {
                $content = of_get_option('default_tag_banner_content');
                $content = preg_replace('/<p class="heading-style">([^<]*)<\/p>/i', '<p class="heading-style">"' . $title . '"</p>', $content);
                $this->includesTitle = true;
            }
        } else if (is_archive() && is_category() && is_main_query() && !in_the_loop()) {
            $category = get_category(get_query_var('cat'));
            $this->image = get_field('banner_image', "{$category->taxonomy}_{$category->term_id}");
            $content = get_field('banner_content', "{$category->taxonomy}_{$category->term_id}", false);
        } else {
            $object = $post;
            if (empty($object)) {
                $object = get_queried_object();
            }

            if ($object instanceof WP_Post) {
                $this->image = get_post_meta($object->ID, 'banner_image', true);
                $content = get_post_meta($object->ID, 'banner_content', true);
            } else if ($object instanceof WP_Term) {
                $this->image = get_field('banner_image', "{$object->taxonomy}_{$object->term_id}");
                $content = get_field('banner_content', "{$object->taxonomy}_{$object->term_id}", false);
            }
        }

        if (preg_match('/^[0-9]+$/i', $this->image)) {
            $this->image = (int)$this->image;
        }

        if (!empty($this->image) && !is_numeric($this->image)) {
            global $wpdb;
            $this->image = $wpdb->get_var($wpdb->prepare("SELECT ID FROM {$wpdb->posts} WHERE guid = '%s' AND post_type = 'attachment'", $this->image));
        }

        if (empty($this->image) && defined('DEFAULT_BANNER_IMAGE')) {
            $this->image = DEFAULT_BANNER_IMAGE;
        }

        $this->image = apply_filters('module_banner_image', $this->image);

        $this->includesTitle = preg_match('/<h1(.*)>(.*)<\/h1>/is', $content) > 0;
        if (!is_null($title) && $this->includesTitle) {
            $content = preg_replace('/<h1(.*)>(.*)<\/h1>/is', '<h1 itemprop="name"$1>' . $title . '</h1>', $content);
        }
        if (!empty($content)) {
            $content = str_replace('class="heading-style"', 'class="heading-style"' . (!is_single() ? ' itemprop="name"' : ''), $content);
            $content = str_replace('<p>', '<p' . (!is_single() ? ' itemprop="description"' : '') . '>', $content);
        }
        $this->includesTitle = strpos($content, 'class="heading-style"') > 0;
        $this->content = apply_filters('module_banner_content', $content);
    }

    function display()
    {
        include(locate_template('module-banner.php'));
    }

    function displayImage()
    {
        if (!empty($this->image)) {
            include(locate_template('module-banner-image.php'));
        }
    }

}

if (!function_exists('enqueue_banner_style_and_script')) {
    add_action('wp_enqueue_scripts', 'enqueue_banner_style_and_script');
    function enqueue_banner_style_and_script()
    {
        wp_register_script('banner-script', get_template_directory_uri() . '/modules/banner/banner.js', array(), '1.0', true);
        wp_enqueue_script('banner-script');
        wp_enqueue_style('banner-style', get_template_directory_uri() . '/modules/banner/banner.css', array(), '1.0', 'all');
    }
}