<div class="row loop">
    <?php while (have_posts()) : the_post(); ?>
        <div class="item col-xs-12 col-sm-12 col-sm-original-4 col-md-4 col-lg-4">
            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                <header>
                    <?php
                    $title = get_the_title();
                    if (is_category()) :
	                    $meta = get_option('wpseo_taxonomy_meta');
	                    if (array_key_exists(get_the_ID(), $meta['product_cat']) && array_key_exists('wpseo_title', $meta['product_cat'][get_the_ID()])) :
		                    $title = $meta['product_cat'][get_the_ID()]['wpseo_title'];
	                    endif;
                    else :
                        $seo_title = get_post_meta(get_the_ID(), '_yoast_wpseo_title', true);
                        if (empty($seo_title)) :
                            $title = $seo_title;
                        endif;
                    endif;
                    ?>
                    <a href="<?php the_permalink(); ?>" class="image-container"
                       title="<?php echo $title; ?>">
                        <span class="image-wrapper">
                            <?php
                            $banner = new Banner(null, 'medium');
                            $banner->displayImage();
                            ?>
                        </span>
                    </a>
                    <?php if (is_archive() && is_main_query()) : ?>
                        <h2 class="post-title">
                            <a href="<?php the_permalink(); ?>"
                               title="<?php echo $title; ?>">
                                <?php the_title(); ?>
                            </a>
                        </h2>
                    <?php else : ?>
                        <h3 class="post-title">
                            <a href="<?php the_permalink(); ?>"
                               title="<?php echo $title; ?>">
                                <?php the_title(); ?>
                            </a>
                        </h3>
                    <?php endif; ?>
                    <p class="post-date">
                        <time datetime="<?php echo get_the_date('c'); ?>">
                            <small><?php the_time(get_option('date_format')); ?></small>
                        </time>
                    </p>
                </header>
                <p class="post-content"><?php the_excerpt(); ?></p>
                <p class="text-right">
                    <?php echo do_shortcode('[read_more_button]'); ?>
                </p>
            </article>
        </div>
    <?php endwhile; ?>
</div>