<?php
$employee_ids = get_field('specialists');
if (is_array($employee_ids)) {
    array_walk($employee_ids, function ($post_id) {
        return (int)$post_id;
    });
    $employees = new WP_Query(array(
        'posts_per_page' => 1,
        'ignore_sticky_posts' => true,
        'post_type' => 'employee',
        'post__in' => $employee_ids,
        'orderby' => 'rand'
    ));
    $original_post_id = get_the_ID();
    ob_start();
    while ($employees->have_posts()) {
        $employees->the_post();
        ?>
        <div class="author row">
            <div class="col-xs-6 col-sm-6 col-md-6 col-lg-6">
                <h3><?php _e('De auteur', 'base-theme'); ?></h3>
                <p class="name"><?php the_title(); ?></p>
                <p class="role"><?php the_field('employee_role'); ?></p>
                <p class="contact">
                    <a href="mailto:<?php the_field('employee_email'); ?>"
                       title="<?php echo get_post_meta(get_the_ID(), '_yoast_wpseo_title', true); ?>">
                        <i class="fa fa-envelope-o"></i>
                    </a>
                </p>
            </div>
            <div class="col-xs-6 col-sm-6 col-md-6 col-lg-6">
                <?php the_post_thumbnail('large', array('class' => 'img-responsive')); ?>
            </div>
        </div>
        <?php
    }
    $output = ob_get_clean();
    wp_reset_postdata();
}
