<?php get_template_part('module', 'social-side-menu'); ?>

<footer>
    <div class="footer-inner">
        <div class="container">

        <div class="footer-address">
            <address>
                <p class="organization-name">
                    <a href="<?php echo home_url('/'); ?>" title="<?php get_seo_title(get_option('page_on_front')); ?>">
                        <?php echo of_get_option('company'); ?>
                    </a>
                </p>
                <p>
                    <span class="street-address">
                        <?php echo of_get_option('street') . ' ' . of_get_option('number'); ?>
                    </span><br>
                    <span class="postal-code">
                        <?php echo of_get_option('zip'); ?>
                    </span><br/>
                    <span class="locality">
                        <?php echo of_get_option('city'); ?>
                    </span><br/>
                    <a href="tel:<?php echo preg_replace('/[^\d\+]+/i', '', preg_replace('/\(.+\)/i', '', of_get_option('phone'))); ?>"
                       title="<?php printf(__('Bel %s', 'base-theme'), get_bloginfo('name')); ?>" class="tel">
                        <?php echo of_get_option('phone'); ?>
                    </a><br/>
                    <a href="mailto:<?php echo get_option('admin_email'); ?>" class="email"
                       title="<?php printf(__('Stuur een e-mail naar %s', 'base-theme'), get_bloginfo('name')); ?>">
                        <?php echo get_option('admin_email'); ?>
                    </a>
                </p>
                <p class="social">
                    <?php
                    $social = get_option('wpseo_social');
                    $allowed_keys = ['facebook_site', 'twitter_site', 'linkedin_url', 'google_plus_url', 'youtube_url'];
                    $urls = array_filter(array_intersect_key($social, array_flip($allowed_keys)));
                    foreach ($urls as $key => $url) :
                        if ($key === 'twitter_site') :
                            $url = 'https://www.twitter.com/' . $url;
                        endif;
                        $brand = str_replace('_', '-', str_replace(array('_site', '_url'), '', $key));
                        ?>
                        <a href="<?php echo $url; ?>" rel="nofollow"
                           title="<?php printf(__('Volg ons op %s', 'base-theme'), $brand); ?>">
                            <i class="fa fa-<?php echo $brand; ?>"></i>
                        </a>
                        <?php
                    endforeach;
                    ?>
                </p>
                <?php $company_logo_id = of_get_option('company_logo');
                if (!empty($company_logo_id)) : ?>
                    <div class="company-logo">
                        <?php
                        if (!is_numeric($company_logo_id)) :
                            global $wpdb;
                            $company_logo_id = $wpdb->get_var($wpdb->prepare("SELECT ID FROM {$wpdb->posts} WHERE guid = '%s' AND post_type = 'attachment'", $company_logo_id));
                        endif;
                        $alt_title = get_post_meta(get_option('page_on_front'), '_yoast_wpseo_title', true);
                        echo wp_get_attachment_image($company_logo_id, 'medium', false, array('class' => 'img-responsive'));
                        ?>
                    </div>
                <?php endif; ?>
            </address>
        </div>


        <div id="copyright-terms">
            <div class="container">
                <div class="copyright-terms-wrapper">
                    <p class="copyright">
                        &copy; <?php echo of_get_option('company'); ?> 2011-<?php echo date('Y'); ?>.
                        <?php _e('Alle rechten voorbehouden.', 'base-theme'); ?>
                    </p>
                </div>
            </div>
        </div>


    </div>
</footer>
<?php wp_footer(); ?>
</body>
</html>
