<!doctype html>
<html <?php language_attributes(); ?> class="no-js">
<head>
    <meta http-equiv="content-type" content="text/html; charset=<?php bloginfo('charset'); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1.0">
    <base href="<?php echo esc_url(home_url('/')); ?>">
    <title><?php wp_title('|'); ?></title>
    <link href="http://www.google-analytics.com" rel="dns-prefetch">
    <?php wp_head(); ?>
    <!--[if lte IE 9]>
    <script type="text/javascript" src="https://raw.githubusercontent.com/aFarkas/html5shiv/master/dist/html5shiv.min.js"></script>
    <script type="text/javascript" src="https://raw.githubusercontent.com/livingston/css3-mediaqueries-js/master/css3-mediaqueries.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/respond.js/1.4.2/respond.js"></script>
    <![endif]-->
    <!--[if lt IE 9]>
    <script src="http://code.jquery.com/jquery-1.11.3.min.js"></script>
    <![endif]-->
    <!--[if gte IE 9]><!-->
    <script src="http://code.jquery.com/jquery-2.1.4.min.js"></script>
    <!--<![endif]-->
    <script type="text/javascript">
        var ajaxurl = "<?php echo admin_url('admin-ajax.php'); ?>";
    </script>
</head>
<body <?php body_class(); ?>>
<header>
    <nav class="navbar navbar-default">
        <div class="container">
            <div class="navbar-addition hidden-xs">
                <a href="mailto:<?php echo get_option('admin_email'); ?>"
                   title="<?php printf(__('Email %s' ,'base-theme'), get_bloginfo('name')); ?>">
                    <i class="fa fa-envelope"></i>
                    <?php echo get_option('admin_email'); ?>
                </a>
                <a href="tel:<?php echo preg_replace('/[^\d\+]+/i', '', preg_replace('/\(.+\)/i', '', of_get_option('phone'))); ?>"
                   title="<?php printf(__('Bel %s','base-theme'), get_bloginfo('name')); ?>">
                    <i class="fa fa-phone"></i>
                    <?php echo of_get_option('phone'); ?>
                </a>
            </div>
            <div class="navbar-header">
                <a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>"
                   title="<?php echo get_post_meta(get_option('page_on_front'), '_yoast_wpseo_title', true); ?>">
                    <?php
                    $company_logo_id = of_get_option('company_logo');
                    if (!empty($company_logo_id) && !is_numeric($company_logo_id)) :
                        global $wpdb;
	                    $company_logo_id = $wpdb->get_var($wpdb->prepare("SELECT ID FROM {$wpdb->posts} WHERE guid = '%s' AND post_type = 'attachment'", $company_logo_id));
                    endif;
                    $alt_title = get_post_meta(get_option('page_on_front'), '_yoast_wpseo_title', true);
                    echo wp_get_attachment_image($company_logo_id, 'medium', false, array('alt' => $alt_title, 'title' => $alt_title));
                    ?>
                </a>
                <div class="visible-xs phone-number">
                    <div>
                        <a href="tel:<?php echo preg_replace('/[^\d\+]+/i', '', preg_replace('/\(.+\)/i', '', of_get_option('phone'))); ?>"
                           title="<?php printf(__('Bel %s','base-theme'), get_bloginfo('name')); ?>">
                            <i class="fa fa-phone"></i>
                        </a>
                    </div>
                </div>
                <div class="visible-xs email">
                    <div>
                        <a href="mailto:<?php echo get_option('admin_email'); ?>"
                           title="<?php printf(__('Email %s','base-theme'), get_bloginfo('name')); ?>">
                            <i class="fa fa-envelope"></i>
                        </a>
                    </div>
                </div>
                <div class="visible-xs search-button">
                    <div>
                        <a href="<?php echo home_url('/'); ?>?s=" title="<?php _e('Zoeken' ,'base-theme'); ?>">
                            <i class="fa fa-search"></i>
                        </a>
                    </div>
                </div>
                <div class="toggle-button">
                    <div>
                        <button type="button" class="navbar-toggle collapsed" data-toggle="collapse"
                                data-target="#header-nav-menu" aria-expanded="false">
                            <i class="fa fa-bars" aria-hidden="true"></i>
                            <span class="sr-only"><?php _e('Open het menu', 'base-theme'); ?></span>
                        </button>
                    </div>
                </div>
            </div>
            <?php wp_nav_menu(array(
                'theme_location' => 'header',
                'container' => 'div',
                'container_class' => 'collapse navbar-collapse',
                'container_id' => 'header-nav-menu',
                'menu_class' => 'nav navbar-nav',
                'fallback_cb' => 'wp_bootstrap_navwalker::fallback',
                'walker' => new wp_bootstrap_navwalker()
            )); ?>
        </div>
    </nav>
</header>
