<?php

if (!function_exists('register_slides')) {
    add_action('init', 'register_slides');
    function register_slides()
    {
        register_post_type('slide', array(
            'labels' => array(
                'name' => __('Slides', 'base-theme'),
                'singular_name' => __('Slide', 'base-theme'),
                'menu_name' => __('Slides', 'base-theme'),
                'name_admin_bar' => __('Slide', 'base-theme'),
                'add_new' => __('Toevoegen', 'base-theme'),
                'add_new_item' => __('Slide toevoegen', 'base-theme'),
                'new_item' => __('Nieuwe slide', 'base-theme'),
                'edit_item' => __('Bewerken', 'base-theme'),
                'view_item' => __('Bekijken', 'base-theme'),
                'all_items' => __('Alle slides', 'base-theme'),
                'search_items' => __('Slides zoeken', 'base-theme'),
                'not_found' => __('Geen slides gevonden.', 'base-theme'),
                'not_found_in_trash' => __('Geen slides gevonden in de prullenbak.', 'base-theme'),
            ),
            'description' => __('Homepage slides', 'base-theme'),
            'public' => false,
            'publicly_queryable' => false,
            'show_ui' => true,
            'show_in_menu' => true,
            'menu_position' => 20,
            'menu_icon' => 'dashicons-format-gallery',
            'capability_type' => 'post',
            'has_archive' => false,
            'hierarchical' => false,
            'supports' => array('title', 'editor', 'thumbnail')
        ));
    }
}

if (!function_exists('bootstrap_gallery')) {
    /**
     * Convert galleries into bootstrap carousels
     */
    add_filter('post_gallery', 'bootstrap_gallery', 100, 3);
    function bootstrap_gallery($output, $atts)
    {
        if (array_key_exists('ids', $atts)) {
            $images = explode(',', $atts['ids']);
            ob_start();
            include(locate_template('module-gallery.php'));
            $output = ob_get_clean();
        }
        return $output;
    }
}

if (!function_exists('enqueue_gallery_style_and_script')) {
    add_action('wp_enqueue_scripts', 'enqueue_gallery_style_and_script');
    function enqueue_gallery_style_and_script()
    {
        wp_register_script('gallery', get_template_directory_uri() . '/modules/gallery/gallery.js', array(), '1.0', true);
        wp_enqueue_script('gallery');

        if (is_front_page()) {
            wp_register_script('gallery-homepage-script', get_template_directory_uri() . '/modules/gallery/gallery-homepage.js', array(), '1.0', true);
            wp_enqueue_script('gallery-homepage-script');
            wp_enqueue_style('gallery-homepage-style', get_template_directory_uri() . '/modules/gallery/gallery-homepage.css', array(), '1.0', 'all');
        }
    }
}